/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file.nio;

import de.schlichtherle.truezip.fs.file.nio.FileEntry;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class TempFilePool
implements IOPool<FileEntry> {
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    static final TempFilePool INSTANCE = new TempFilePool(null);
    @Nullable
    private final Path dir;

    TempFilePool(@CheckForNull Path dir) {
        this.dir = null != dir ? dir : TEMP_DIR;
    }

    public TempEntry allocate() throws IOException {
        return new TempEntry(Files.createTempFile(this.dir, ".tzp", null, new FileAttribute[0]), this);
    }

    public void release(IOPool.Entry<FileEntry> resource) throws IOException {
        resource.release();
    }

    @NotThreadSafe
    private static final class TempEntry
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        TempEntry(Path file, TempFilePool pool) {
            super(file);
            assert (null != file);
            assert (null != pool);
            this.pool = pool;
        }

        @Override
        public void release() throws IOException {
            if (null == this.pool) {
                throw new IllegalStateException(this.getPath() + " (already released)");
            }
            this.pool(null);
        }

        private void pool(@CheckForNull TempFilePool newPool) throws IOException {
            TempFilePool oldPool = this.pool;
            this.pool = newPool;
            if (oldPool != newPool) {
                Files.deleteIfExists(this.getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

