/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.http;

import de.schlichtherle.truezip.fs.http.HttpEntry;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class HttpInputSocket
extends InputSocket<HttpEntry> {
    private final HttpEntry entry;

    HttpInputSocket(HttpEntry entry) {
        assert (null != entry);
        this.entry = entry;
    }

    public HttpEntry getLocalTarget() {
        return this.entry;
    }

    public ReadOnlyFile newReadOnlyFile() throws IOException {
        final IOPool.Entry temp = (IOPool.Entry)this.entry.getController().getDriver().getPool().allocate();
        try {
            Streams.copy((InputStream)this.entry.getConnection().getInputStream(), (OutputStream)temp.getOutputSocket().newOutputStream());
        }
        catch (IOException ex) {
            temp.release();
            throw ex;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TempReadOnlyFile
        extends DecoratingReadOnlyFile {
            boolean closed;

            TempReadOnlyFile() throws IOException {
                super(entry.getInputSocket().newReadOnlyFile());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    super.close();
                }
                finally {
                    temp.release();
                }
            }
        }
        return new TempReadOnlyFile();
    }

    public InputStream newInputStream() throws IOException {
        return this.entry.getConnection().getInputStream();
    }
}

