/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.http;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.http.HttpController;
import de.schlichtherle.truezip.fs.http.HttpInputSocket;
import de.schlichtherle.truezip.fs.http.HttpOutputSocket;
import de.schlichtherle.truezip.fs.http.ReadOnlyFileSystemTypeException;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;

@Immutable
public class HttpEntry
extends FsEntry
implements IOEntry<HttpEntry> {
    private final HttpController controller;
    private final String name;
    protected final URI uri;

    HttpEntry(HttpController controller, FsEntryName name) {
        assert (null != controller);
        this.controller = controller;
        this.name = name.toString();
        this.uri = controller.resolve(name).toUri();
    }

    final IOPool<?> getPool() {
        return this.controller.getPool();
    }

    private HttpResponse executeHead() throws IOException {
        return this.controller.executeHead(this);
    }

    private HttpResponse executeGet() throws IOException {
        return this.controller.executeGet(this);
    }

    protected HttpUriRequest newHead() {
        return new HttpHead(this.uri);
    }

    protected HttpUriRequest newGet() {
        return new HttpGet(this.uri);
    }

    @CheckForNull
    private String getHeaderField(String name) throws IOException {
        Header header = this.executeHead().getLastHeader(name);
        return null == header ? null : header.getValue();
    }

    protected InputStream getInputStream() throws IOException {
        HttpResponse response = this.executeGet();
        HttpEntity entity = response.getEntity();
        if (null == entity) {
            throw new FileNotFoundException(this.name + " (" + response.getStatusLine() + ")");
        }
        return entity.getContent();
    }

    protected OutputStream getOutputStream() throws IOException {
        throw new ReadOnlyFileSystemTypeException();
    }

    public String getName() {
        return this.name;
    }

    public Set<Entry.Type> getTypes() {
        try {
            if (null != this.executeHead()) {
                return FILE_TYPE_SET;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    public boolean isType(Entry.Type type) {
        if (Entry.Type.FILE != type) {
            return false;
        }
        try {
            if (null != this.executeHead()) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public long getSize(Entry.Size type) {
        if (Entry.Size.DATA != type) {
            return -1L;
        }
        try {
            String field = this.getHeaderField("content-length");
            if (null != field) {
                return Long.parseLong(field);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        try {
            String field = this.getHeaderField("last-modified");
            if (null != field) {
                return Date.parse(field);
            }
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Nullable
    public Set<String> getMembers() {
        return null;
    }

    public InputSocket<HttpEntry> getInputSocket() {
        return this.newInputSocket((BitField<FsInputOption>)FsInputOptions.NONE);
    }

    protected InputSocket<HttpEntry> newInputSocket(BitField<FsInputOption> options) {
        return new HttpInputSocket(this, options);
    }

    public OutputSocket<HttpEntry> getOutputSocket() {
        return this.newOutputSocket((BitField<FsOutputOption>)FsOutputOptions.NONE, null);
    }

    protected OutputSocket<HttpEntry> newOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new HttpOutputSocket(this, options, template);
    }
}

