/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileTestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.junit.Assert;

public final class RaesTest
extends ReadOnlyFileTestCase {
    private static final Logger logger = Logger.getLogger(RaesTest.class.getName());
    private static final String PASSWD = "secret";
    private static final RandomGenerator rng = new DigestRandomGenerator((Digest)new SHA256Digest());
    private static final Type0RaesParameters.KeyStrength[] keyStrengths;
    private File cipherFile;

    private static RaesParameters newRaesParameters() {
        return new Type0RaesParameters(){
            boolean secondTry;

            public Type0RaesParameters.KeyStrength getKeyStrength() {
                byte[] buf = new byte[1];
                rng.nextBytes(buf);
                return keyStrengths[(buf[0] & 0xFF) % keyStrengths.length];
            }

            public char[] getOpenPasswd(boolean invalid) {
                Assert.assertEquals((Object)this.secondTry, (Object)invalid);
                if (this.secondTry) {
                    logger.finer("First returned password was wrong, providing the right one now!");
                    return RaesTest.PASSWD.toCharArray();
                }
                this.secondTry = true;
                byte[] buf = new byte[1];
                rng.nextBytes(buf);
                return buf[0] >= 0 ? RaesTest.PASSWD.toCharArray() : "wrong".toCharArray();
            }

            public char[] getCreatePasswd() {
                return RaesTest.PASSWD.toCharArray();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReadOnlyFile newReadOnlyFile(File plainFile) throws IOException {
        FileInputStream in = new FileInputStream(plainFile);
        try {
            this.cipherFile = File.createTempFile("tzp", null);
            try {
                RaesOutputStream out = RaesOutputStream.getInstance((OutputStream)new FileOutputStream(this.cipherFile), (RaesParameters)RaesTest.newRaesParameters());
                Streams.copy((InputStream)in, (OutputStream)out);
                logger.log(Level.FINE, "Encrypted {0} bytes of random data using AES-{1}/CTR/Hmac-SHA-256/PBKDFv2.", new Object[]{plainFile.length(), out.getKeySizeBits()});
            }
            catch (IOException ex) {
                File cipherFile = this.cipherFile;
                this.cipherFile = null;
                if (!cipherFile.delete()) {
                    throw new IOException(cipherFile + " (could not delete)", ex);
                }
                throw ex;
            }
            RaesReadOnlyFile raesReadOnlyFile = RaesReadOnlyFile.getInstance((File)this.cipherFile, (RaesParameters)RaesTest.newRaesParameters());
            return raesReadOnlyFile;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws IOException {
        try {
            super.tearDown();
        }
        finally {
            File cipherFile = this.cipherFile;
            this.cipherFile = null;
            if (null != cipherFile && cipherFile.exists() && !cipherFile.delete()) {
                logger.log(Level.WARNING, "{0} (File.delete() failed)", cipherFile);
            }
        }
    }

    static {
        rng.addSeedMaterial(System.currentTimeMillis());
        keyStrengths = Type0RaesParameters.KeyStrength.values();
    }
}

