/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.swing;

import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.swing.AesKeyStrengthPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.CreateKeyPanel;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JFileChooserOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JPasswordFieldOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.util.NameComponentChooser;

public final class CreateKeyPanelTest {
    private CreateKeyPanel instance;
    private JFrameOperator frame;
    private JLabelOperator errorLabel;
    private final ComponentChooser keyFileChooser = new NameComponentChooser("keyFileChooser");

    @Before
    public void setUp() throws Exception {
        this.instance = new CreateKeyPanel();
        this.frame = this.showInstanceInFrame();
        this.errorLabel = this.findErrorLabel(this.frame);
    }

    private JFrameOperator showInstanceInFrame() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.getContentPane().add((Component)CreateKeyPanelTest.this.instance);
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
        return new JFrameOperator();
    }

    private JLabelOperator findErrorLabel(JFrameOperator frame) {
        String error = "error";
        this.instance.setError("error");
        JLabelOperator errorLabel = new JLabelOperator((ContainerOperator)frame, "error");
        ((JFrame)frame.getSource()).pack();
        this.instance.setError(null);
        return errorLabel;
    }

    @After
    public void tearDown() throws Exception {
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CreateKeyPanelTest.this.frame.dispose();
            }
        });
    }

    @Test
    public void testResourceID() {
        URI id = URI.create("HelloWorld!");
        this.instance.setResource(id);
        Assert.assertEquals((Object)id, (Object)this.instance.getResource());
        new JTextComponentOperator((ContainerOperator)this.frame, id.toString());
    }

    @Test
    public void testSetError() {
        this.instance.setError("This is a test error message!");
        Assert.assertFalse((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        new JTextFieldOperator((ContainerOperator)this.frame).typeText("secret");
        Assert.assertTrue((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        this.instance.setError("This is a test error message!");
        Assert.assertFalse((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        new JTabbedPaneOperator((ContainerOperator)this.frame).selectPage(1);
        new JButtonOperator((ContainerOperator)this.frame, this.keyFileChooser).push();
        new JFileChooserOperator().chooseFile("file");
        Assert.assertTrue((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() <= 0;
    }

    @Test
    public void testPasswd() {
        AesCipherParameters param = new AesCipherParameters();
        Assert.assertFalse((boolean)this.instance.updateCreateKey(param));
        Assert.assertNull((Object)param.getPassword());
        Assert.assertFalse((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        new JPasswordFieldOperator((ContainerOperator)this.frame, 0).setText("foofoo");
        new JPasswordFieldOperator((ContainerOperator)this.frame, 1).setText("barbar");
        Assert.assertFalse((boolean)this.instance.updateCreateKey(param));
        Assert.assertNull((Object)param.getPassword());
        Assert.assertFalse((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        String passwd = "secre";
        new JPasswordFieldOperator((ContainerOperator)this.frame, 0).setText(passwd);
        new JPasswordFieldOperator((ContainerOperator)this.frame, 1).setText(passwd);
        Assert.assertFalse((boolean)this.instance.updateCreateKey(param));
        Assert.assertNull((Object)param.getPassword());
        Assert.assertFalse((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        passwd = "secret";
        new JPasswordFieldOperator((ContainerOperator)this.frame, 0).setText(passwd);
        new JPasswordFieldOperator((ContainerOperator)this.frame, 1).setText(passwd);
        Assert.assertTrue((boolean)this.instance.updateCreateKey(param));
        Assert.assertEquals((Object)passwd, (Object)new String(param.getPassword()));
        Assert.assertTrue((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
    }

    @Test
    public void testKeyFile() {
        AesCipherParameters param = new AesCipherParameters();
        new JTabbedPaneOperator((ContainerOperator)this.frame).selectPage(1);
        new JButtonOperator((ContainerOperator)this.frame, this.keyFileChooser).push();
        new JFileChooserOperator().chooseFile("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!\"$%&/()=?");
        Assert.assertTrue((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        Assert.assertFalse((boolean)this.instance.updateCreateKey(param));
        Assert.assertFalse((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        new JButtonOperator((ContainerOperator)this.frame, this.keyFileChooser).push();
        JFileChooserOperator fc = new JFileChooserOperator();
        File[] files = fc.getFiles();
        fc.cancel();
        for (File file : files) {
            if (!file.isFile()) continue;
            new JButtonOperator((ContainerOperator)this.frame, this.keyFileChooser).push();
            fc = new JFileChooserOperator();
            fc.setSelectedFile(file);
            fc.approve();
            if (this.instance.updateCreateKey(param)) {
                Assert.assertNotNull((Object)param.getPassword());
                Assert.assertTrue((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
                continue;
            }
            Assert.assertFalse((boolean)CreateKeyPanelTest.isBlank(this.errorLabel.getText()));
        }
    }

    @Test
    public void testExtraDataUI() {
        AesKeyStrengthPanel ui = new AesKeyStrengthPanel();
        this.instance.setExtraDataUI((JComponent)ui);
        this.frame.pack();
        Assert.assertSame((Object)ui, (Object)this.instance.getExtraDataUI());
        new JComboBoxOperator((ContainerOperator)this.frame);
    }

    static {
        JemmyProperties.setCurrentOutput((TestOut)TestOut.getNullOutput());
    }
}

