/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileTestCase;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.zip.raes.SafeZipRaesDriver;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesDriver;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerService;
import de.schlichtherle.truezip.key.KeyPromptingCancelledException;
import de.schlichtherle.truezip.key.PromptingKeyManager;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import java.io.File;
import java.io.IOException;
import java.util.ServiceConfigurationError;
import org.junit.Assert;
import org.junit.Test;

public final class TZipRaesFileTest
extends TFileTestCase {
    private static boolean cancelling;

    public TZipRaesFileTest() {
        super(FsScheme.create((String)"tzp"), (FsArchiveDriver)new SafeZipRaesDriver(POOL_SERVICE, new CustomKeyManagerService()){

            public ZipRaesDriver.KeyProviderSyncStrategy getKeyProviderSyncStrategy() {
                return ZipRaesDriver.KeyProviderSyncStrategy.RESET_UNCONDITIONALLY;
            }
        });
    }

    public void setUp() throws IOException {
        cancelling = false;
        super.setUp();
    }

    @Test
    public void testCancelling() throws IOException {
        cancelling = true;
        TFile archive = new TFile(this.getArchive().getPath());
        TFile entry1 = new TFile((File)archive, "entry1");
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        Assert.assertFalse((boolean)entry1.mkdirs());
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        try {
            Assert.assertFalse((boolean)entry1.createNewFile());
            Assert.fail((String)"An IOException should have been thrown because password prompting has been disabled!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        TFile entry2 = new TFile((File)entry1, "entry2");
        Assert.assertFalse((boolean)entry2.mkdirs());
        Assert.assertFalse((boolean)new File(entry2.getPath()).exists());
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        try {
            Assert.assertFalse((boolean)entry2.createNewFile());
            Assert.fail((String)"An IOException should have been thrown because password prompting has been disabled!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)new File(entry2.getPath()).exists());
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
    }

    @Test
    public void testFileStatus() throws IOException {
        TFile archive = this.getArchive();
        TFile inner = new TFile((File)archive, "inner" + this.getSuffix());
        Assert.assertTrue((boolean)archive.mkdir());
        Assert.assertTrue((boolean)inner.mkdir());
        TFile.umount();
        cancelling = true;
        Assert.assertTrue((boolean)archive.exists());
        Assert.assertFalse((boolean)archive.isDirectory());
        Assert.assertFalse((boolean)archive.isFile());
        TFile.umount();
        cancelling = false;
        Assert.assertTrue((boolean)archive.exists());
        Assert.assertTrue((boolean)archive.isDirectory());
        Assert.assertFalse((boolean)archive.isFile());
        cancelling = true;
        Assert.assertTrue((boolean)inner.exists());
        Assert.assertFalse((boolean)inner.isDirectory());
        Assert.assertFalse((boolean)inner.isFile());
        TFile.umount();
        Assert.assertFalse((boolean)archive.deleteAll());
        TFile.umount();
        cancelling = false;
        Assert.assertTrue((boolean)archive.deleteAll());
    }

    private static class CustomUI
    implements PromptingKeyProvider.UI<AesCipherParameters> {
        private CustomUI() {
        }

        public void promptCreateKey(PromptingKeyProvider<? super AesCipherParameters> provider) throws UnknownKeyException {
            if (cancelling) {
                throw new KeyPromptingCancelledException();
            }
            AesCipherParameters param = new AesCipherParameters();
            param.setPassword("secret".toCharArray());
            provider.setKey((SafeKey)param);
        }

        public void promptOpenKey(PromptingKeyProvider<? super AesCipherParameters> provider, boolean invalid) throws UnknownKeyException {
            this.promptCreateKey(provider);
        }
    }

    private static class CustomKeyManagerService
    implements KeyManagerService {
        private static final PromptingKeyManager<AesCipherParameters> manager = new PromptingKeyManager((PromptingKeyProvider.UI)new CustomUI());

        private CustomKeyManagerService() {
        }

        public <K> KeyManager<? extends K, ?> getManager(Class<K> type) {
            if (type.isAssignableFrom(AesCipherParameters.class)) {
                return manager;
            }
            throw new ServiceConfigurationError("No service available for " + type);
        }
    }
}

