/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import java.net.URI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class KeyManagerTestCase {
    private KeyManager<?, ?> instance;

    @Before
    public void setUp() {
        this.instance = this.newKeyManager();
    }

    protected abstract KeyManager<?, ?> newKeyManager();

    @Test
    public final void testGetKeyProvider() {
        URI id = URI.create("a");
        try {
            this.instance.getKeyProvider(null);
            Assert.fail((String)"A NullPointerException is expected from the previous call!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        KeyProvider prov1 = this.instance.getKeyProvider(id);
        Assert.assertNotNull((Object)prov1);
        KeyProvider prov2 = this.instance.getKeyProvider(id);
        Assert.assertSame((Object)prov1, (Object)prov2);
    }

    @Test
    public final void testMoveKeyProvider() {
        URI idA = URI.create("a");
        URI idB = URI.create("b");
        try {
            this.instance.moveKeyProvider(null, null);
            Assert.fail((String)"A NullPointerException is expected from the previous call!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.instance.moveKeyProvider(idA, null);
            Assert.fail((String)"A NullPointerException is expected from the previous call!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.instance.moveKeyProvider(null, idB);
            Assert.fail((String)"A NullPointerException is expected from the previous call!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        boolean result = this.instance.moveKeyProvider(idA, idB);
        Assert.assertFalse((boolean)result);
        KeyProvider provA1 = this.instance.getKeyProvider(idA);
        Assert.assertNotNull((Object)provA1);
        result = this.instance.moveKeyProvider(idA, idB);
        Assert.assertTrue((boolean)result);
        KeyProvider provA2 = this.instance.getKeyProvider(idA);
        Assert.assertNotNull((Object)provA2);
        Assert.assertFalse((boolean)provA1.equals(provA2));
        KeyProvider provB1 = this.instance.getKeyProvider(idB);
        Assert.assertNotNull((Object)provB1);
        Assert.assertSame((Object)provA1, (Object)provB1);
    }

    @Test
    public final void testRemoveKeyProvider() {
        URI id = URI.create("a");
        boolean result = this.instance.removeKeyProvider(id);
        Assert.assertFalse((boolean)result);
        KeyProvider prov1 = this.instance.getKeyProvider(id);
        result = this.instance.removeKeyProvider(id);
        Assert.assertTrue((boolean)result);
        result = this.instance.removeKeyProvider(id);
        Assert.assertFalse((boolean)result);
        KeyProvider prov2 = this.instance.getKeyProvider(id);
        result = this.instance.removeKeyProvider(id);
        Assert.assertTrue((boolean)result);
        result = this.instance.removeKeyProvider(id);
        Assert.assertFalse((boolean)result);
        Assert.assertFalse((boolean)prov1.equals(prov2));
    }
}

