/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.swing;

import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.EnhancedPanelTest;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.EventListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;

public final class EnhancedPanelTest {
    private EnhancedPanel instance;

    @Before
    public void setUp() {
        this.instance = new EnhancedPanel();
        this.instance.add((Component)new JLabel("Hello world!"));
    }

    @Test
    public void testGetAncestorWindow() throws InterruptedException, InvocationTargetException {
        Assert.assertNull((Object)new EnhancedPanel().getAncestorWindow());
        JFrame frame = EnhancedPanelTest.showInNewFrame((Component)this.instance);
        Window window1 = this.instance.getAncestorWindow();
        Assert.assertSame((Object)frame, (Object)window1);
        EnhancedPanelTest.disposeFrame(frame);
        frame = EnhancedPanelTest.showInNewFrame((Component)this.instance);
        Window window2 = this.instance.getAncestorWindow();
        Assert.assertSame((Object)frame, (Object)window2);
        EnhancedPanelTest.disposeFrame(frame);
        Assert.assertNotSame((Object)window1, (Object)window2);
    }

    private static JFrame showInNewFrame(final Component instance) throws InterruptedException, InvocationTargetException {
        final JFrame frame = new JFrame();
        EnhancedPanelTest.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.getContentPane().add(instance);
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
        return frame;
    }

    private static void disposeFrame(final JFrame frame) throws InterruptedException, InvocationTargetException {
        EnhancedPanelTest.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
                frame.dispose();
            }
        });
    }

    @Test
    public void testPanelListeners0() {
        PanelListener[] listeners = this.instance.getPanelListeners();
        Assert.assertEquals((long)0L, (long)listeners.length);
        CountingPanelListener listener = null;
        try {
            this.instance.addPanelListener(listener);
            Assert.fail((String)"Previous method call should throw an NPE!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        listeners = this.instance.getPanelListeners();
        Assert.assertEquals((long)0L, (long)listeners.length);
        try {
            this.instance.removePanelListener(listener);
            Assert.fail((String)"Previous method call should throw an NPE!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        listeners = this.instance.getPanelListeners();
        Assert.assertEquals((long)0L, (long)listeners.length);
        listener = new CountingPanelListener();
        this.instance.addPanelListener((PanelListener)listener);
        listeners = this.instance.getPanelListeners();
        Assert.assertEquals((long)1L, (long)listeners.length);
        Assert.assertSame((Object)listener, (Object)listeners[0]);
        this.instance.addPanelListener((PanelListener)listener);
        listeners = this.instance.getPanelListeners();
        Assert.assertEquals((long)2L, (long)listeners.length);
        Assert.assertSame((Object)listener, (Object)listeners[0]);
        Assert.assertSame((Object)listener, (Object)listeners[1]);
        this.instance.removePanelListener((PanelListener)listener);
        listeners = this.instance.getPanelListeners();
        Assert.assertEquals((long)1L, (long)listeners.length);
        Assert.assertSame((Object)listener, (Object)listeners[0]);
        this.instance.removePanelListener((PanelListener)listener);
        listeners = this.instance.getPanelListeners();
        Assert.assertEquals((long)0L, (long)listeners.length);
    }

    @Test
    public void testPanelListeners1() {
        EventListener[] listeners = this.instance.getListeners(PanelListener.class);
        Assert.assertEquals((long)0L, (long)listeners.length);
        CountingPanelListener listener = null;
        try {
            this.instance.addPanelListener(listener);
            Assert.fail((String)"Previous method call should throw an NPE!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        listeners = this.instance.getListeners(PanelListener.class);
        Assert.assertEquals((long)0L, (long)listeners.length);
        try {
            this.instance.removePanelListener(listener);
            Assert.fail((String)"Previous method call should throw an NPE!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        listeners = this.instance.getListeners(PanelListener.class);
        Assert.assertEquals((long)0L, (long)listeners.length);
        listener = new CountingPanelListener();
        this.instance.addPanelListener((PanelListener)listener);
        listeners = this.instance.getListeners(PanelListener.class);
        Assert.assertEquals((long)1L, (long)listeners.length);
        Assert.assertSame((Object)listener, (Object)listeners[0]);
        this.instance.addPanelListener((PanelListener)listener);
        listeners = this.instance.getListeners(PanelListener.class);
        Assert.assertEquals((long)2L, (long)listeners.length);
        Assert.assertSame((Object)listener, (Object)listeners[0]);
        Assert.assertSame((Object)listener, (Object)listeners[1]);
        this.instance.removePanelListener((PanelListener)listener);
        listeners = this.instance.getListeners(PanelListener.class);
        Assert.assertEquals((long)1L, (long)listeners.length);
        Assert.assertSame((Object)listener, (Object)listeners[0]);
        this.instance.removePanelListener((PanelListener)listener);
        listeners = this.instance.getListeners(PanelListener.class);
        Assert.assertEquals((long)0L, (long)listeners.length);
    }

    @Test
    public void testFireAncestorWindowShown() {
        CountingPanelListener l = new CountingPanelListener();
        this.instance.addPanelListener((PanelListener)l);
        this.instance.addPanelListener((PanelListener)l);
        Assert.assertEquals((long)0L, (long)l.shown);
        PanelEvent event = null;
        this.instance.fireAncestorWindowShown(event);
        Assert.assertEquals((long)2L, (long)l.shown);
    }

    @Test
    public void testFireAncestorWindowHidden() {
        CountingPanelListener l = new CountingPanelListener();
        this.instance.addPanelListener((PanelListener)l);
        this.instance.addPanelListener((PanelListener)l);
        Assert.assertEquals((long)0L, (long)l.hidden);
        PanelEvent event = null;
        this.instance.fireAncestorWindowHidden(event);
        Assert.assertEquals((long)2L, (long)l.hidden);
    }

    @Test
    public void testEvents4JFrame() throws Exception {
        CountingPanelListener l = new CountingPanelListener();
        this.instance.addPanelListener((PanelListener)l);
        JFrame frame1 = new JFrame();
        class SetupFrame
        extends 1FrameHolder
        implements Runnable {
            SetupFrame(JFrame frame) {
                class FrameHolder {
                    protected final JFrame frame;
                    final /* synthetic */ EnhancedPanelTest this$0;

                    protected FrameHolder(EnhancedPanelTest enhancedPanelTest, JFrame frame) {
                        this.this$0 = enhancedPanelTest;
                        this.frame = frame;
                    }
                }
                super(EnhancedPanelTest.this, frame);
            }

            @Override
            public void run() {
                this.frame.getContentPane().add((Component)EnhancedPanelTest.this.instance);
                this.frame.pack();
                this.frame.setLocationRelativeTo(null);
            }
        }
        EnhancedPanelTest.invokeAndWait(new SetupFrame(frame1));
        class MakeFrameVisible
        extends 1FrameHolder
        implements Runnable {
            MakeFrameVisible(JFrame frame) {
                super(EnhancedPanelTest.this, frame);
            }

            @Override
            public void run() {
                this.frame.show();
                this.frame.setVisible(true);
            }
        }
        class MakeFrameInvisible
        extends 1FrameHolder
        implements Runnable {
            MakeFrameInvisible(JFrame frame) {
                super(EnhancedPanelTest.this, frame);
            }

            @Override
            public void run() {
                this.frame.setVisible(false);
                this.frame.hide();
                this.frame.dispose();
            }
        }
        this.events(new MakeFrameVisible(frame1), new MakeFrameInvisible(frame1), l);
        JFrame frame2 = new JFrame();
        EnhancedPanelTest.invokeAndWait(new SetupFrame(frame2));
        this.events(new MakeFrameVisible(frame2), new MakeFrameInvisible(frame2), l);
    }

    private void events(Runnable makeVisible, Runnable makeInvisible, CountingPanelListener l) throws Exception {
        l.hidden = 0;
        l.shown = 0;
        for (int i = 1; i <= 3; ++i) {
            EnhancedPanelTest.invokeAndWait(makeVisible);
            Assert.assertEquals((long)i, (long)l.shown);
            Assert.assertEquals((long)(i - 1), (long)l.hidden);
            EnhancedPanelTest.invokeAndWait(makeInvisible);
            Assert.assertEquals((long)i, (long)l.shown);
            Assert.assertEquals((long)i, (long)l.hidden);
        }
    }

    private static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
        EnhancedPanelTest.waitEmptyQueue();
    }

    private static void waitEmptyQueue() throws AssertionError {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (queue.peekEvent() != null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            catch (InvocationTargetException cannotHappen) {
                throw new AssertionError((Object)cannotHappen);
            }
            catch (InterruptedException continueAnyway) {
                continueAnyway.printStackTrace();
            }
        }
    }

    @Test
    public void testEvents4JOptionPane() throws Exception {
        CountingPanelListener l = new CountingPanelListener();
        this.instance.addPanelListener((PanelListener)l);
        Runnable makeVisible = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, EnhancedPanelTest.this.instance);
            }
        };
        for (int i = 1; i <= 3; ++i) {
            EventQueue.invokeLater(makeVisible);
            JDialogOperator dialogOp = new JDialogOperator();
            EnhancedPanelTest.waitEmptyQueue();
            Assert.assertEquals((long)i, (long)l.shown);
            Assert.assertEquals((long)(i - 1), (long)l.hidden);
            JButtonOperator buttonOp = new JButtonOperator((ContainerOperator)dialogOp);
            buttonOp.push();
            EnhancedPanelTest.waitEmptyQueue();
            Assert.assertEquals((long)i, (long)l.shown);
            Assert.assertEquals((long)i, (long)l.hidden);
        }
    }

    static {
        JemmyProperties.setCurrentOutput((TestOut)TestOut.getNullOutput());
    }

    private static class CountingPanelListener
    implements PanelListener {
        public int shown;
        public int hidden;

        private CountingPanelListener() {
        }

        public void ancestorWindowShown(PanelEvent evt) {
            ++this.shown;
        }

        public void ancestorWindowHidden(PanelEvent evt) {
            ++this.hidden;
        }
    }
}

