/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import de.schlichtherle.truezip.zip.ZipTestCase;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RaesZipTest
extends ZipTestCase {
    private static final Logger logger = Logger.getLogger(RaesZipTest.class.getName());
    private static int AUTHENTICATION_TRIGGER = 524288;
    private static final String PASSWD = "passwd";
    private static final Type0RaesParameters.KeyStrength[] keyStrengths = Type0RaesParameters.KeyStrength.values();
    private static final Random rnd = new Random();
    private static final RaesParameters raesParameters = new Type0RaesParameters(){

        public char[] getOpenPasswd(boolean invalid) {
            return RaesZipTest.PASSWD.toCharArray();
        }

        public char[] getCreatePasswd() {
            return RaesZipTest.PASSWD.toCharArray();
        }

        public Type0RaesParameters.KeyStrength getKeyStrength() {
            return RaesZipTest.createKeyStrength();
        }
    };

    private static Type0RaesParameters.KeyStrength createKeyStrength() {
        Type0RaesParameters.KeyStrength keyStrength = keyStrengths[rnd.nextInt(keyStrengths.length)];
        logger.log(Level.FINE, "Using {0} bits cipher key.", 128 + keyStrength.ordinal() * 64);
        return keyStrength;
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out) throws IOException {
        RaesOutputStream ros = RaesOutputStream.getInstance((OutputStream)out, (RaesParameters)raesParameters);
        try {
            return new ZipOutputStream((OutputStream)ros);
        }
        catch (RuntimeException exc) {
            ros.close();
            throw exc;
        }
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out, Charset charset) throws IOException {
        RaesOutputStream ros = RaesOutputStream.getInstance((OutputStream)out, (RaesParameters)raesParameters);
        try {
            return new ZipOutputStream((OutputStream)ros, charset);
        }
        catch (RuntimeException exc) {
            ros.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(String name) throws IOException {
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)new File(name), (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(String name, Charset charset) throws IOException {
        if (charset == null) {
            throw new NullPointerException();
        }
        new String(new byte[0], charset);
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)new File(name), (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof, charset);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(File file) throws IOException {
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)file, (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(File file, Charset charset) throws IOException {
        if (charset == null) {
            throw new NullPointerException();
        }
        new String(new byte[0], charset);
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)file, (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof, charset);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(ReadOnlyFile file) throws IOException {
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((ReadOnlyFile)file, (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(ReadOnlyFile file, Charset charset) throws IOException {
        if (charset == null) {
            throw new NullPointerException();
        }
        new String(new byte[0], charset);
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((ReadOnlyFile)file, (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof, charset);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }
}

