/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.awt;

import de.schlichtherle.truezip.awt.EventDispatchTimeoutException;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class EventQueueHelper {
    private static final byte RESET = 0;
    private static final byte CANCELLED = 1;
    private static final byte STARTED = 2;
    private static final byte DONE = 3;

    private EventQueueHelper() {
    }

    public static void invokeAndWaitUninterruptibly(Runnable task) throws InvocationTargetException {
        try {
            EventQueueHelper.invokeAndWait(task, false, 0L);
        }
        catch (EventDispatchTimeoutException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (InterruptedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public static void invokeAndWaitUninterruptibly(Runnable task, long startTimeout) throws EventDispatchTimeoutException, InvocationTargetException {
        try {
            EventQueueHelper.invokeAndWait(task, false, startTimeout);
        }
        catch (InterruptedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeAndWait(Runnable task, boolean interruptibly, long startTimeout) throws EventDispatchTimeoutException, InterruptedException, InvocationTargetException {
        if (startTimeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative!");
        }
        if (EventQueue.isDispatchThread()) {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }
        class MonitoredAction
        implements Runnable {
            Thread edt;
            Throwable throwable;
            byte status = 0;
            final /* synthetic */ Runnable val$task;

            MonitoredAction(Runnable runnable) {
                this.val$task = runnable;
            }

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                if (this.start()) {
                    try {
                        this.val$task.run();
                        this.finished(null);
                    }
                    catch (Throwable throwable) {
                        this.finished(throwable);
                    }
                }
            }

            private synchronized boolean start() {
                if (this.status == 1) {
                    return false;
                }
                this.edt = Thread.currentThread();
                this.status = (byte)2;
                this.notifyAll();
                return true;
            }

            private synchronized void finished(Throwable t) {
                this.throwable = t;
                this.status = (byte)3;
                Thread.interrupted();
                this.notifyAll();
            }
        }
        MonitoredAction action = new MonitoredAction(task);
        EventQueue.invokeLater(action);
        MonitoredAction monitoredAction = action;
        synchronized (monitoredAction) {
            InterruptedException interrupted = null;
            while (action.status < 3) {
                try {
                    action.wait(action.status < 2 ? startTimeout : 0L);
                    if (action.status >= 2) continue;
                    action.status = 1;
                    throw new EventDispatchTimeoutException(startTimeout);
                }
                catch (InterruptedException ex) {
                    interrupted = ex;
                    if (!interruptibly) continue;
                    break;
                }
            }
            if (interrupted != null) {
                if (interruptibly) {
                    if (action.status >= 2) {
                        action.edt.interrupt();
                    }
                    throw interrupted;
                }
                Thread.currentThread().interrupt();
            }
            if (action.throwable != null) {
                throw new InvocationTargetException(action.throwable);
            }
        }
    }
}

