/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.CipherOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesParametersAgent;
import de.schlichtherle.truezip.crypto.raes.RaesParametersException;
import de.schlichtherle.truezip.crypto.raes.Type0RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.Mac;

public abstract class RaesOutputStream
extends CipherOutputStream {
    static void klac(Mac klac, long length, byte[] buf) {
        for (int i = 0; i < 8; ++i) {
            klac.update((byte)length);
            length >>= 8;
        }
        int bufLen = klac.doFinal(buf, 0);
        assert (bufLen == buf.length);
    }

    public static RaesOutputStream getInstance(OutputStream out, RaesParameters parameters) throws NullPointerException, IllegalArgumentException, RaesParametersException, IOException {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (parameters instanceof Type0RaesParameters) {
            return new Type0RaesOutputStream(out, (Type0RaesParameters)parameters);
        }
        if (parameters instanceof RaesParametersAgent) {
            parameters = ((RaesParametersAgent)parameters).getParameters(RaesParameters.class);
            return RaesOutputStream.getInstance(out, parameters);
        }
        throw new RaesParametersException();
    }

    RaesOutputStream(OutputStream out, BufferedBlockCipher cipher) {
        super(out, cipher);
    }

    public abstract int getKeySizeBits();
}

