/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.SICSeekableBlockCipher;
import de.schlichtherle.truezip.crypto.raes.RaesKeyException;
import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.io.LEDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;

class Type0RaesOutputStream
extends RaesOutputStream {
    private static final SecureRandom secureRandom = new SecureRandom();
    static final int ITERATION_COUNT = 2005;
    private int keyStrengthBits;
    private Mac mac;
    private Mac klac;
    private LEDataOutputStream dos;
    private long start;
    private boolean closed;

    Type0RaesOutputStream(OutputStream out, Type0RaesParameters param) throws NullPointerException, IllegalArgumentException, RaesKeyException, IOException {
        super(out, null);
        assert (null != out);
        assert (null != param);
        char[] passwd = param.getCreatePasswd();
        if (null == passwd) {
            throw new RaesKeyException();
        }
        int keyStrength = param.getKeyStrength().ordinal();
        SHA256Digest digest = new SHA256Digest();
        int keyStrengthBytes = 16 + keyStrength * 8;
        this.keyStrengthBits = keyStrengthBytes * 8;
        assert (digest.getDigestSize() >= keyStrengthBytes);
        byte[] salt = new byte[keyStrengthBytes];
        Type0RaesOutputStream.generateSalt((Digest)digest, salt);
        PKCS12ParametersGenerator gen = new PKCS12ParametersGenerator((Digest)digest);
        byte[] pass = PBEParametersGenerator.PKCS12PasswordToBytes((char[])passwd);
        int i = passwd.length;
        while (--i >= 0) {
            passwd[i] = '\u0000';
        }
        gen.init(pass, salt, 2005);
        ParametersWithIV cipherParam = (ParametersWithIV)gen.generateDerivedParameters(this.keyStrengthBits, 128);
        CipherParameters macParam = gen.generateDerivedMacParameters(this.keyStrengthBits);
        int i2 = pass.length;
        while (--i2 >= 0) {
            pass[i2] = 0;
        }
        BufferedBlockCipher cipher = new BufferedBlockCipher((BlockCipher)new SICSeekableBlockCipher((BlockCipher)new AESFastEngine()));
        cipher.init(true, (CipherParameters)cipherParam);
        this.mac = new HMac((Digest)new SHA256Digest());
        this.mac.init(macParam);
        this.klac = new HMac((Digest)digest);
        this.klac.init(macParam);
        byte[] cipherKey = ((KeyParameter)cipherParam.getParameters()).getKey();
        this.klac.update(cipherKey, 0, cipherKey.length);
        this.dos = new LEDataOutputStream(out);
        this.delegate = new MacOutputStream((OutputStream)this.dos, this.mac);
        this.dos.writeInt(1397047634);
        this.dos.writeByte(0);
        this.dos.writeByte(keyStrength);
        this.dos.writeShort(2005);
        this.dos.write(salt);
        this.start = this.dos.size();
        assert ((long)(8 + salt.length) == this.start);
        this.cipher = cipher;
    }

    private static void generateSalt(Digest digest, byte[] salt) {
        DigestRandomGenerator randomGenerator = new DigestRandomGenerator(digest);
        randomGenerator.addSeedMaterial(secureRandom.generateSeed(salt.length));
        randomGenerator.nextBytes(salt);
    }

    @Override
    public int getKeySizeBits() {
        return this.keyStrengthBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.finish();
                long trailer = this.dos.size();
                assert (this.mac.getMacSize() == this.klac.getMacSize());
                byte[] buf = new byte[this.mac.getMacSize()];
                long length = trailer - this.start;
                Type0RaesOutputStream.klac(this.klac, length, buf);
                this.dos.write(buf, 0, buf.length / 2);
                int bufLen = this.mac.doFinal(buf, 0);
                assert (bufLen == buf.length);
                this.dos.write(buf, 0, buf.length / 2);
                assert (this.dos.size() - trailer == (long)buf.length);
            }
            finally {
                super.close();
            }
        }
    }
}

