/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param;

import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.key.SafeKey;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;

public final class AesCipherParameters
implements SafeKey<AesCipherParameters> {
    private Type0RaesParameters.KeyStrength keyStrength = Type0RaesParameters.KeyStrength.BITS_256;
    private char[] password;

    @Override
    public AesCipherParameters clone() {
        try {
            AesCipherParameters clone = (AesCipherParameters)super.clone();
            if (null != this.password) {
                clone.password = (char[])this.password.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public void reset() {
        this.setPassword(null);
        this.setKeyStrength(Type0RaesParameters.KeyStrength.BITS_256);
    }

    @NonNull
    public Type0RaesParameters.KeyStrength getKeyStrength() {
        return this.keyStrength;
    }

    public void setKeyStrength(@NonNull Type0RaesParameters.KeyStrength keyStrength) {
        if (null == keyStrength) {
            throw new NullPointerException();
        }
        this.keyStrength = keyStrength;
    }

    @Nullable
    public char[] getPassword() {
        return null == this.password ? null : (char[])this.password.clone();
    }

    public void setPassword(@Nullable char[] newPW) {
        char[] oldPW = this.password;
        if (null != oldPW) {
            Arrays.fill(oldPW, '\u0000');
        }
        if (null != newPW) {
            this.password = (char[])newPW.clone();
            Arrays.fill(newPW, '\u0000');
        } else {
            this.password = null;
        }
    }

    public void setKeyFileBytes(@Nullable byte[] bytes) {
        char[] oldPW = this.password;
        if (null != oldPW) {
            Arrays.fill(oldPW, '\u0000');
        }
        if (null != bytes) {
            int len = bytes.length;
            char[] newPW = new char[len >>= 1];
            int off = 0;
            for (int i = 0; i < len; ++i) {
                newPW[i] = (char)(bytes[off++] << 8 | bytes[off++] & 0xFF);
            }
            this.password = newPW;
            Arrays.fill(bytes, (byte)0);
        } else {
            this.password = null;
        }
    }
}

