/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param;

import de.schlichtherle.truezip.crypto.raes.RaesKeyException;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesParametersAgent;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.key.KeyManagerService;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;

@DefaultAnnotation(value={NonNull.class})
public final class KeyManagerRaesParameters
implements RaesParametersAgent {
    private final KeyManagerService service;
    private final URI resource;

    public KeyManagerRaesParameters(KeyManagerService service, URI resource) {
        if (null == service) {
            throw new NullPointerException();
        }
        if (!resource.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        this.service = service;
        this.resource = resource;
    }

    @Override
    public RaesParameters getParameters(Class<? extends RaesParameters> type) {
        return new Type0();
    }

    private class Type0
    implements Type0RaesParameters {
        private AesCipherParameters param;

        private Type0() {
        }

        @Override
        public Type0RaesParameters.KeyStrength getKeyStrength() {
            assert (null != this.param) : "getCreatePasswd() must get called first!";
            return this.param.getKeyStrength();
        }

        @Override
        public char[] getCreatePasswd() throws RaesKeyException {
            Object provider = KeyManagerRaesParameters.this.service.getManager(AesCipherParameters.class).getKeyProvider(KeyManagerRaesParameters.this.resource);
            try {
                this.param = (AesCipherParameters)provider.getCreateKey();
                return this.param.getPassword();
            }
            catch (UnknownKeyException failure) {
                throw new RaesKeyException(failure);
            }
        }

        @Override
        public char[] getOpenPasswd(boolean invalid) throws RaesKeyException {
            Object provider = KeyManagerRaesParameters.this.service.getManager(AesCipherParameters.class).getKeyProvider(KeyManagerRaesParameters.this.resource);
            try {
                return ((AesCipherParameters)provider.getOpenKey(invalid)).getPassword();
            }
            catch (UnknownKeyException failure) {
                throw new RaesKeyException(failure);
            }
        }
    }
}

