/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.console;

import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import java.io.Console;
import java.net.URI;
import java.util.Arrays;
import java.util.ResourceBundle;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class AesCipherParametersUI
implements PromptingKeyProvider.UI<AesCipherParameters> {
    private static final String CLASS_NAME = AesCipherParametersUI.class.getName();
    static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    static final Console con = System.console();
    private static final PromptingLock lock = new PromptingLock();
    private static final int MIN_PASSWD_LEN = 6;
    private static URI lastResource = URI.create("");
    private static final String YES = resources.getString("yes");
    private static final String NO = resources.getString("no");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void promptCreateKey(PromptingKeyProvider<? super AesCipherParameters> provider) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            char[] newPasswd1;
            URI resource = provider.getResource();
            assert (null != resource) : "violation of contract for PromptingKeyProviderUI";
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("createKey.banner"), resource);
            }
            lastResource = resource;
            AesCipherParameters param = new AesCipherParameters();
            while (true) {
                if (null == (newPasswd1 = con.readPassword(resources.getString("createKey.newPasswd1"), new Object[0])) || newPasswd1.length <= 0) {
                    return;
                }
                char[] newPasswd2 = con.readPassword(resources.getString("createKey.newPasswd2"), new Object[0]);
                if (newPasswd2 == null) {
                    return;
                }
                if (!Arrays.equals(newPasswd1, newPasswd2)) {
                    con.printf(resources.getString("createKey.passwd.noMatch"), new Object[0]);
                    continue;
                }
                if (newPasswd1.length >= 6) break;
                con.printf(resources.getString("createKey.passwd.tooShort"), new Object[0]);
            }
            param.setPassword(newPasswd1);
            con.printf(resources.getString("keyStrength.banner"), new Object[0]);
            con.printf(resources.getString("keyStrength.medium"), new Object[0]);
            con.printf(resources.getString("keyStrength.high"), new Object[0]);
            con.printf(resources.getString("keyStrength.ultra"), new Object[0]);
            block11: while (true) {
                String keyStrength;
                if (null == (keyStrength = con.readLine(resources.getString("keyStrength.prompt"), provider)) || keyStrength.length() <= 0) {
                    return;
                }
                try {
                    switch (Integer.parseInt(keyStrength)) {
                        case 128: {
                            param.setKeyStrength(Type0RaesParameters.KeyStrength.BITS_128);
                            break block11;
                        }
                        case 192: {
                            param.setKeyStrength(Type0RaesParameters.KeyStrength.BITS_192);
                            break block11;
                        }
                        case 256: {
                            param.setKeyStrength(Type0RaesParameters.KeyStrength.BITS_256);
                            break block11;
                        }
                    }
                }
                catch (NumberFormatException syntaxError) {}
            }
            provider.setKey(param);
        }
    }

    @Override
    public void promptOpenKey(PromptingKeyProvider<? super AesCipherParameters> provider, boolean invalid) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            String changeKey;
            if (invalid) {
                con.printf(resources.getString("openKey.invalid"), new Object[0]);
            }
            URI resource = provider.getResource();
            assert (resource != null) : "violation of contract for PromptingKeyProviderUI";
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("openKey.banner"), resource);
            }
            lastResource = resource;
            char[] passwd = con.readPassword(resources.getString("openKey.passwd"), new Object[0]);
            if (null == passwd || passwd.length <= 0) {
                provider.setKey(null);
                return;
            }
            AesCipherParameters param = new AesCipherParameters();
            param.setPassword(passwd);
            provider.setKey(param);
            do {
                changeKey = con.readLine(resources.getString("openKey.change"), new Object[0]);
                provider.setChangeKeySelected(YES.equalsIgnoreCase(changeKey));
            } while (null != changeKey && changeKey.length() > 0 && !YES.equalsIgnoreCase(changeKey) && !NO.equalsIgnoreCase(changeKey));
            return;
        }
    }

    private static class PromptingLock {
        private PromptingLock() {
        }
    }
}

