/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.swing;

import de.schlichtherle.truezip.awt.EventDispatchTimeoutException;
import de.schlichtherle.truezip.awt.EventQueueHelper;
import de.schlichtherle.truezip.awt.Windows;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.swing.AesKeyStrengthPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.BasicInvalidKeyFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.BasicUnknownKeyFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.CreateKeyPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.InvalidKeyFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.OpenKeyPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.UnknownKeyFeedback;
import de.schlichtherle.truezip.key.KeyPromptingInterruptedException;
import de.schlichtherle.truezip.key.KeyPromptingTimeoutException;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public final class AesCipherParametersUI
implements PromptingKeyProvider.UI<AesCipherParameters> {
    private static final String CLASS_NAME = AesCipherParametersUI.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    static final URI INITIAL_RESOURCE = URI.create("");
    private static final long START_PROMPTING_TIMEOUT = 1000L;
    public static final int KEY_FILE_LEN = 512;
    private static final Map<PromptingKeyProvider<?>, OpenKeyPanel> openKeyPanels = new WeakHashMap();
    private static final ServiceLocator serviceLocator = new ServiceLocator(AesCipherParametersUI.class.getClassLoader());
    static volatile URI lastResource = INITIAL_RESOURCE;
    private volatile UnknownKeyFeedback unknownKeyFeedback;
    private volatile InvalidKeyFeedback invalidKeyFeedback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readKeyFile(File file) throws IOException {
        byte[] buf = new byte[512];
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.readFully(buf);
        }
        finally {
            raf.close();
        }
        return buf;
    }

    UnknownKeyFeedback getUnknownKeyFeedback() {
        if (this.unknownKeyFeedback == null) {
            this.unknownKeyFeedback = (UnknownKeyFeedback)serviceLocator.getService(UnknownKeyFeedback.class, BasicUnknownKeyFeedback.class);
        }
        return this.unknownKeyFeedback;
    }

    void setUnkownKeyFeedback(UnknownKeyFeedback uckf) {
        this.unknownKeyFeedback = uckf;
    }

    InvalidKeyFeedback getInvalidKeyFeedback() {
        if (this.invalidKeyFeedback == null) {
            this.invalidKeyFeedback = (InvalidKeyFeedback)serviceLocator.getService(InvalidKeyFeedback.class, BasicInvalidKeyFeedback.class);
        }
        return this.invalidKeyFeedback;
    }

    void setInvalidKeyFeedback(InvalidKeyFeedback ickf) {
        this.invalidKeyFeedback = ickf;
    }

    @Override
    public void promptCreateKey(final PromptingKeyProvider<? super AesCipherParameters> provider) throws UnknownKeyException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AesCipherParametersUI.this.promptCreateKeyEDT(provider);
            }
        };
        AesCipherParametersUI.multiplexOnEDT(task);
    }

    @Override
    public void promptOpenKey(final PromptingKeyProvider<? super AesCipherParameters> provider, final boolean invalid) throws UnknownKeyException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AesCipherParametersUI.this.promptOpenKeyEDT(provider, invalid);
            }
        };
        AesCipherParametersUI.multiplexOnEDT(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptCreateKeyEDT(PromptingKeyProvider<? super AesCipherParameters> provider) {
        assert (EventQueue.isDispatchThread());
        AesCipherParameters param = new AesCipherParameters();
        AesKeyStrengthPanel keyStrengthPanel = new AesKeyStrengthPanel();
        keyStrengthPanel.setKeyStrength(param.getKeyStrength());
        CreateKeyPanel createKeyPanel = new CreateKeyPanel();
        createKeyPanel.setExtraDataUI((JComponent)((Object)keyStrengthPanel));
        Window parent = Windows.getParentWindow();
        try {
            while (!Thread.interrupted()) {
                URI resource = provider.getResource();
                assert (null != resource) : "violation of contract for PromptingKeyProviderUI";
                createKeyPanel.setResource(resource);
                createKeyPanel.setFeedback(createKeyPanel.getError() != null ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
                int result = JOptionPane.showConfirmDialog(parent, (Object)createKeyPanel, resources.getString("newPasswdDialog.title"), 2, 3);
                if (Thread.interrupted()) {
                    break;
                }
                if (result != 0) {
                    break;
                }
                if (createKeyPanel.updateCreateKey(param)) {
                    param.setKeyStrength(keyStrengthPanel.getKeyStrength());
                    provider.setKey(param);
                    break;
                }
                assert (createKeyPanel.getError() != null);
            }
        }
        finally {
            AesCipherParametersUI.eventuallyDispose(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptOpenKeyEDT(PromptingKeyProvider<? super AesCipherParameters> provider, boolean invalid) {
        OpenKeyPanel openKeyPanel;
        assert (EventQueue.isDispatchThread());
        AesCipherParameters param = new AesCipherParameters();
        if (invalid) {
            OpenKeyPanel panel = openKeyPanels.get(provider);
            openKeyPanel = panel != null ? panel : new OpenKeyPanel();
            openKeyPanel.setError(resources.getString("invalidKey"));
        } else {
            openKeyPanel = new OpenKeyPanel();
        }
        openKeyPanels.put(provider, openKeyPanel);
        Window parent = Windows.getParentWindow();
        try {
            while (!Thread.interrupted()) {
                int result;
                URI resource = provider.getResource();
                assert (resource != null) : "violation of contract for PromptingKeyProviderUI";
                openKeyPanel.setResource(resource);
                openKeyPanel.setFeedback(null != openKeyPanel.getError() ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
                try {
                    result = JOptionPane.showConfirmDialog(parent, (Object)openKeyPanel, resources.getString("passwdDialog.title"), 2, 3);
                }
                catch (StackOverflowError failure) {
                    boolean interrupted = Thread.interrupted();
                    assert (interrupted);
                    break;
                }
                if (Thread.interrupted()) {
                    break;
                }
                if (result != 0) {
                    provider.setKey(null);
                    break;
                }
                if (openKeyPanel.updateOpenKey(param)) {
                    provider.setKey(param);
                    provider.setChangeKeySelected(openKeyPanel.isChangeKeySelected());
                    break;
                }
                assert (openKeyPanel.getError() != null);
            }
        }
        finally {
            AesCipherParametersUI.eventuallyDispose(parent);
        }
    }

    private static void eventuallyDispose(Window window) {
        if (!window.isShowing()) {
            window.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void multiplexOnEDT(Runnable task) throws UnknownKeyException {
        if (Thread.interrupted()) {
            throw new KeyPromptingInterruptedException();
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        Class<AesCipherParametersUI> clazz = AesCipherParametersUI.class;
        synchronized (AesCipherParametersUI.class) {
            try {
                EventQueueHelper.invokeAndWaitUninterruptibly(task, 1000L);
            }
            catch (EventDispatchTimeoutException ex) {
                throw new KeyPromptingTimeoutException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnknownKeyException(ex);
            }
            finally {
                Thread.interrupted();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

