/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.swing;

import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.swing.AesCipherParametersUI;
import de.schlichtherle.truezip.crypto.raes.param.swing.AuthenticationPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.Feedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.WeakKeyException;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@DefaultAnnotation(value={NonNull.class})
final class CreateKeyPanel
extends EnhancedPanel {
    private static final String CLASS_NAME = CreateKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final int MIN_PASSWD_LEN = 6;
    private static final long serialVersionUID = 6416529465492387235L;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private Feedback feedback;
    private AuthenticationPanel authenticationPanel;
    private JLabel error;
    private JPasswordField newPasswd1;
    private JLabel newPasswd1Label;
    private JPasswordField newPasswd2;
    private JLabel newPasswd2Label;
    private EnhancedPanel newPasswdPanel;
    private JTextPane resource;

    public CreateKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreateKeyPanel.this.setError(null);
            }
        };
        this.newPasswd1.getDocument().addDocumentListener(dl);
        this.newPasswd2.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resource.getForeground();
    }

    private Font getBoldFont() {
        Font font = this.resource.getFont();
        return new Font(font.getName(), 1, font.getSize());
    }

    URI getResource() {
        return URI.create(this.resource.getText());
    }

    void setResource(URI resource) {
        URI lastResource = AesCipherParametersUI.lastResource;
        assert (lastResource != null) : "violation of contract in PromptingKeyProvider";
        if (!lastResource.equals(resource) && !lastResource.equals(AesCipherParametersUI.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(resource.toString());
        AesCipherParametersUI.lastResource = resource;
    }

    boolean updateCreateKey(AesCipherParameters param) {
        try {
            switch (this.authenticationPanel.getAuthenticationMethod()) {
                case 0: {
                    char[] newPasswd1Content = this.newPasswd1.getPassword();
                    char[] newPasswd2Content = this.newPasswd2.getPassword();
                    if (Arrays.equals(newPasswd1Content, newPasswd2Content)) {
                        Arrays.fill(newPasswd2Content, '\u0000');
                        this.checkPasswdCreateKey(newPasswd1Content);
                        this.setError(null);
                        param.setPassword(newPasswd1Content);
                        return true;
                    }
                    this.setError(resources.getString("passwd.noMatch"));
                    return false;
                }
                case 1: {
                    byte[] key;
                    File keyFile = this.authenticationPanel.getKeyFile();
                    if (keyFile.canWrite()) {
                        this.setError(resources.getString("keyFile.canWrite"));
                        return false;
                    }
                    try {
                        key = AesCipherParametersUI.readKeyFile(keyFile);
                    }
                    catch (EOFException ex) {
                        this.setError(resources.getString("keyFile.eofException"));
                        return false;
                    }
                    catch (FileNotFoundException ex) {
                        this.setError(resources.getString("keyFile.fileNotFoundException"));
                        return false;
                    }
                    catch (IOException ex) {
                        this.setError(resources.getString("keyFile.ioException"));
                        return false;
                    }
                    this.checkKeyFileCreateKey(key);
                    this.setError(null);
                    param.setKeyFileBytes(key);
                    return true;
                }
            }
            throw new AssertionError((Object)"Unsupported authentication method!");
        }
        catch (WeakKeyException failure) {
            this.setError(failure.getLocalizedMessage());
            return false;
        }
    }

    void checkKeyFileCreateKey(byte[] createKey) throws WeakKeyException {
        Deflater def = new Deflater();
        def.setInput(createKey);
        def.finish();
        assert (def.getTotalOut() == 0);
        int n = def.deflate(new byte[createKey.length * 2]);
        assert (def.getTotalOut() == n);
        def.end();
        if (n < 64) {
            throw new WeakKeyException(CreateKeyPanel.localizedMessage(resources, "keyFile.badEntropy", null));
        }
    }

    void checkPasswdCreateKey(char[] createKey) throws WeakKeyException {
        if (createKey.length < 6) {
            throw new WeakKeyException(CreateKeyPanel.localizedMessage(resources, "passwd.tooShort", 6));
        }
    }

    private static String localizedMessage(ResourceBundle resources, String key, @CheckForNull Object param) {
        return param != null ? MessageFormat.format(resources.getString(key), param) : resources.getString(key);
    }

    @CheckForNull
    String getError() {
        String error = this.error.getText();
        return error.trim().length() > 0 ? error : null;
    }

    void setError(@CheckForNull String error) {
        this.error.setText(error != null ? error : " ");
    }

    JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    void setExtraDataUI(JComponent extraDataUI) {
        if (this.extraDataUI == extraDataUI) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (extraDataUI != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add(extraDataUI, gridBagConstraints);
        }
        this.extraDataUI = extraDataUI;
        this.revalidate();
    }

    Feedback getFeedback() {
        return this.feedback;
    }

    void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    private void initComponents() {
        this.newPasswdPanel = new EnhancedPanel();
        this.newPasswd1Label = new JLabel();
        this.newPasswd1 = new JPasswordField();
        this.newPasswd2Label = new JLabel();
        this.newPasswd2 = new JPasswordField();
        JLabel prompt = new JLabel();
        this.resource = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.newPasswdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                CreateKeyPanel.this.newPasswdPanelAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.newPasswdPanel.setLayout((LayoutManager)new GridBagLayout());
        this.newPasswd1Label.setDisplayedMnemonic(resources.getString("newPasswd1").charAt(0));
        this.newPasswd1Label.setLabelFor(this.newPasswd1);
        this.newPasswd1Label.setText(resources.getString("newPasswd1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.newPasswdPanel.add((Component)this.newPasswd1Label, (Object)gridBagConstraints);
        this.newPasswd1.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.newPasswdPanel.add((Component)this.newPasswd1, (Object)gridBagConstraints);
        this.newPasswd2Label.setDisplayedMnemonic(resources.getString("newPasswd2").charAt(0));
        this.newPasswd2Label.setLabelFor(this.newPasswd2);
        this.newPasswd2Label.setText(resources.getString("newPasswd2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.newPasswdPanel.add((Component)this.newPasswd2Label, (Object)gridBagConstraints);
        this.newPasswd2.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.newPasswdPanel.add((Component)this.newPasswd2, (Object)gridBagConstraints);
        this.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                CreateKeyPanel.this.formAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.setLayout(new GridBagLayout());
        prompt.setLabelFor(this.resource);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(prompt, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.getBoldFont());
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add(this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel((JPanel)this.newPasswdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.authenticationPanel, gridBagConstraints);
        this.error.setForeground(new Color(255, 0, 0));
        this.error.setText(" ");
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.error, gridBagConstraints);
    }

    private void formAncestorWindowShown(PanelEvent evt) {
        Feedback feedback = this.getFeedback();
        if (null != feedback) {
            feedback.feedback((JPanel)((Object)this));
        }
    }

    private void newPasswdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        assert (window != null) : "illegal state";
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CreateKeyPanel.this.newPasswd1.requestFocusInWindow()) {
                            CreateKeyPanel.this.newPasswd1.selectAll();
                            CreateKeyPanel.this.newPasswd2.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

