/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.swing;

import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.swing.AesCipherParametersUI;
import de.schlichtherle.truezip.crypto.raes.param.swing.AuthenticationPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.Feedback;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@DefaultAnnotation(value={NonNull.class})
final class OpenKeyPanel
extends EnhancedPanel {
    private static final String CLASS_NAME = OpenKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final long serialVersionUID = 984673974236493651L;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private Feedback feedback;
    private AuthenticationPanel authenticationPanel;
    private final JCheckBox changeKey = new JCheckBox();
    private JLabel error;
    private JPasswordField passwd;
    private JLabel passwdLabel;
    private EnhancedPanel passwdPanel;
    private JTextPane resource;

    public OpenKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OpenKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OpenKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                OpenKeyPanel.this.setError(null);
            }
        };
        this.passwd.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resource.getForeground();
    }

    private Font getBoldFont() {
        return this.resource.getFont().deriveFont(1);
    }

    URI getResource() {
        return URI.create(this.resource.getText());
    }

    void setResource(URI resource) {
        URI lastResource = AesCipherParametersUI.lastResource;
        if (!lastResource.equals(resource) && !lastResource.equals(AesCipherParametersUI.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(resource.toString());
        AesCipherParametersUI.lastResource = resource;
    }

    @CheckForNull
    String getError() {
        String error = this.error.getText();
        return error.trim().length() > 0 ? error : null;
    }

    void setError(@CheckForNull String error) {
        this.error.setText(error != null ? error : " ");
    }

    boolean updateOpenKey(AesCipherParameters param) {
        switch (this.authenticationPanel.getAuthenticationMethod()) {
            case 0: {
                param.setPassword(this.passwd.getPassword());
                return true;
            }
            case 1: {
                File keyFile = this.authenticationPanel.getKeyFile();
                try {
                    param.setKeyFileBytes(AesCipherParametersUI.readKeyFile(keyFile));
                    return true;
                }
                catch (EOFException ex) {
                    this.setError(resources.getString("keyFile.eofException"));
                    return false;
                }
                catch (FileNotFoundException ex) {
                    this.setError(resources.getString("keyFile.fileNotFoundException"));
                    return false;
                }
                catch (IOException ex) {
                    this.setError(resources.getString("keyFile.ioException"));
                    return false;
                }
            }
        }
        throw new AssertionError((Object)"Unsupported authentication method!");
    }

    boolean isChangeKeySelected() {
        return this.changeKey.isSelected();
    }

    void setChangeKeySelected(boolean changeKeySelected) {
        this.changeKey.setSelected(changeKeySelected);
    }

    JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    void setExtraDataUI(JComponent extraDataUI) {
        if (this.extraDataUI == extraDataUI) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (extraDataUI != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add(extraDataUI, gridBagConstraints);
        }
        this.extraDataUI = extraDataUI;
        this.revalidate();
    }

    Feedback getFeedback() {
        return this.feedback;
    }

    void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.passwdLabel = new JLabel();
        this.passwd = new JPasswordField();
        JLabel prompt = new JLabel();
        this.resource = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.passwdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                OpenKeyPanel.this.passwdPanelAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.passwdPanel.setLayout((LayoutManager)new GridBagLayout());
        this.passwdLabel.setDisplayedMnemonic(resources.getString("passwd").charAt(0));
        this.passwdLabel.setLabelFor(this.passwd);
        this.passwdLabel.setText(resources.getString("passwd"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.passwdLabel, (Object)gridBagConstraints);
        this.passwd.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.passwd, (Object)gridBagConstraints);
        this.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                OpenKeyPanel.this.formAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.setLayout(new GridBagLayout());
        prompt.setLabelFor(this.resource);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(prompt, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.getBoldFont());
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add(this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel((JPanel)this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.authenticationPanel, gridBagConstraints);
        this.changeKey.setText(resources.getString("changeKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.changeKey, gridBagConstraints);
        this.error.setForeground(Color.red);
        this.error.setText(" ");
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.error, gridBagConstraints);
    }

    private void formAncestorWindowShown(PanelEvent evt) {
        Feedback feedback = this.getFeedback();
        if (null != feedback) {
            feedback.feedback((JPanel)((Object)this));
        }
    }

    private void passwdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        assert (null != window) : "illegal state";
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (OpenKeyPanel.this.passwd.requestFocusInWindow()) {
                            OpenKeyPanel.this.passwd.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

