/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsTabuException;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEntry;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesDriver;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.CharConversionException;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class KeyManagerArchiveController
extends FsDecoratingController<FsModel, FsController<? extends FsModel>> {
    private final ZipRaesDriver driver;

    KeyManagerArchiveController(FsController<?> controller, ZipRaesDriver driver) {
        super(controller);
        this.driver = driver;
    }

    public final FsEntry getEntry(FsEntryName name) throws IOException {
        try {
            return this.delegate.getEntry(name);
        }
        catch (FsTabuException ex) {
            if (!name.isRoot()) {
                return null;
            }
            FsEntry entry = this.getParent().getEntry(this.getModel().getMountPoint().getPath().resolve(name).getEntryName());
            if (null == entry) {
                return null;
            }
            while (entry instanceof FsArchiveFileSystemEntry) {
                entry = ((FsArchiveFileSystemEntry)entry).getEntry();
            }
            try {
                return FsArchiveFileSystemEntry.create((FsEntryName)FsEntryName.ROOT, (Entry.Type)Entry.Type.SPECIAL, (FsArchiveEntry)this.driver.newEntry(FsEntryName.ROOT.toString(), Entry.Type.SPECIAL, (Entry)entry));
            }
            catch (CharConversionException cannotHappen) {
                throw new AssertionError((Object)cannotHappen);
            }
        }
    }

    public void unlink(FsEntryName name) throws IOException {
        this.delegate.unlink(name);
        if (name.isRoot()) {
            this.driver.getKeyManagerService().getManager(Object.class).removeKeyProvider(this.getModel().getMountPoint().getUri());
        }
    }

    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.delegate.sync(options, handler);
        this.driver.getKeyProviderSyncStrategy().sync((KeyProvider<?>)this.driver.getKeyManagerService().getManager(Object.class).getKeyProvider(this.getModel().getMountPoint().getUri()));
    }
}

