/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesKeyException;
import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.param.KeyManagerRaesParameters;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsTabuException;
import de.schlichtherle.truezip.fs.archive.zip.JarArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.raes.KeyManagerArchiveController;
import de.schlichtherle.truezip.key.KeyManagerService;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPoolService;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.LazyOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public abstract class ZipRaesDriver
extends JarDriver {
    private final KeyManagerService service;

    public ZipRaesDriver(IOPoolService ioPoolService, KeyManagerService keyManagerService) {
        super(ioPoolService);
        if (null == keyManagerService) {
            throw new NullPointerException();
        }
        this.service = keyManagerService;
    }

    public KeyProviderSyncStrategy getKeyProviderSyncStrategy() {
        return KeyProviderSyncStrategy.RESET_CANCELLED_KEY;
    }

    public abstract long getAuthenticationTrigger();

    public final FsController<?> newController(FsMountPoint mountPoint, FsController<?> parent) {
        return new KeyManagerArchiveController(super.newController(mountPoint, parent), this);
    }

    public final JarArchiveEntry newEntry(String path, Entry.Type type, @CheckForNull Entry template) throws CharConversionException {
        JarArchiveEntry entry = super.newEntry(path, type, template);
        if (8 != entry.getMethod()) {
            entry.setMethod(8);
            entry.setCompressedSize(-1L);
        }
        return entry;
    }

    public final ZipInputShop newInputShop(final FsConcurrentModel model, final InputSocket<?> target) throws IOException {
        class Input
        extends DecoratingInputSocket<Entry> {
            Input() {
                super(inputSocket);
            }

            public ReadOnlyFile newReadOnlyFile() throws IOException {
                ReadOnlyFile rof = super.newReadOnlyFile();
                try {
                    RaesReadOnlyFile rrof;
                    try {
                        rrof = RaesReadOnlyFile.getInstance(rof, ZipRaesDriver.this.getRaesParameters((FsModel)model));
                    }
                    catch (RaesKeyException ex) {
                        throw new FsTabuException((FsModel)model, (Throwable)ex);
                    }
                    if (rof.length() <= ZipRaesDriver.this.getAuthenticationTrigger()) {
                        rrof.authenticate();
                    }
                    return rrof;
                }
                catch (IOException ex) {
                    rof.close();
                    throw ex;
                }
            }
        }
        return super.newInputShop(model, (InputSocket)new Input());
    }

    public OutputShop<ZipArchiveEntry> newOutputShop(final FsConcurrentModel model, final OutputSocket<?> target, @CheckForNull InputShop<ZipArchiveEntry> source) throws IOException {
        class Output
        extends DecoratingOutputSocket<Entry> {
            Output() {
                super(outputSocket);
            }

            public OutputStream newOutputStream() throws IOException {
                OutputStream out = new LazyOutputSocket(this.getBoundSocket()).newOutputStream();
                try {
                    try {
                        return RaesOutputStream.getInstance(out, ZipRaesDriver.this.getRaesParameters((FsModel)model));
                    }
                    catch (RaesKeyException ex) {
                        throw new FsTabuException((FsModel)model, (Throwable)ex);
                    }
                }
                catch (IOException cause) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        throw (IOException)ex.initCause(cause);
                    }
                    throw cause;
                }
            }
        }
        return super.newOutputShop(model, (OutputSocket)new Output(), source);
    }

    final KeyManagerService getKeyManagerService() {
        return this.service;
    }

    final RaesParameters getRaesParameters(FsModel model) {
        return new KeyManagerRaesParameters(this.getKeyManagerService(), model.getMountPoint().getUri());
    }

    public static enum KeyProviderSyncStrategy {
        RESET_CANCELLED_KEY{

            @Override
            public void sync(KeyProvider<?> provider) {
                if (provider instanceof PromptingKeyProvider) {
                    ((PromptingKeyProvider)provider).resetCancelledKey();
                }
            }
        }
        ,
        RESET_UNCONDITIONALLY{

            @Override
            public void sync(KeyProvider<?> provider) {
                if (provider instanceof PromptingKeyProvider) {
                    ((PromptingKeyProvider)provider).resetUnconditionally();
                }
            }
        };


        public abstract void sync(KeyProvider<?> var1);
    }
}

