/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyManager;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class PromptingKeyManager<K extends SafeKey<K>>
extends SafeKeyManager<K, PromptingKeyProvider<K>> {
    private final PromptingKeyProvider.UI<? extends K> ui;

    public PromptingKeyManager(PromptingKeyProvider.UI<? extends K> ui) {
        super(new PromptingKeyProviderFactory());
        if (null == ui) {
            throw new NullPointerException();
        }
        this.ui = ui;
    }

    @Override
    public synchronized PromptingKeyProvider<K> getKeyProvider(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.getKeyProvider(resource);
        provider.setResource(resource);
        provider.setUI(this.ui);
        return provider;
    }

    @Override
    public synchronized boolean moveKeyProvider(URI oldResource, URI newResource) {
        boolean changed = super.moveKeyProvider(oldResource, newResource);
        if (changed) {
            PromptingKeyProvider provider = (PromptingKeyProvider)super.getKeyProvider(newResource);
            provider.setResource(newResource);
            provider.setUI(this.ui);
        }
        return changed;
    }

    @Override
    public synchronized boolean removeKeyProvider(URI resource) {
        PromptingKeyProvider provider = (PromptingKeyProvider)super.findKeyProvider(resource);
        boolean changed = super.removeKeyProvider(resource);
        if (changed) {
            provider.setResource(null);
            provider.setUI(null);
        }
        return changed;
    }

    private static class PromptingKeyProviderFactory<K extends SafeKey<K>>
    implements KeyProvider.Factory<K, PromptingKeyProvider<K>> {
        private PromptingKeyProviderFactory() {
        }

        @Override
        public PromptingKeyProvider<K> newKeyProvider() {
            return new PromptingKeyProvider();
        }
    }
}

