/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyPromptingCancelledException;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class PromptingKeyProvider<K extends SafeKey<K>>
extends SafeKeyProvider<K> {
    @NonNull
    private volatile State state = State.RESET;
    private volatile URI resource;
    private volatile UI<? extends K> ui;
    private volatile K key;
    private volatile boolean changeKeySelected;

    public URI getResource() {
        return this.resource;
    }

    void setResource(URI resource) {
        this.resource = resource;
    }

    final UI<? extends K> getUI() {
        return this.ui;
    }

    final void setUI(UI<? extends K> ui) {
        this.ui = ui;
    }

    @NonNull
    State getState() {
        return this.state;
    }

    private void setState(@NonNull State state) {
        this.state = state;
    }

    @Override
    protected final K getCreateKeyImpl() throws UnknownKeyException {
        return this.getState().getCreateKey(this);
    }

    @Override
    protected final K getOpenKeyImpl(boolean invalid) throws UnknownKeyException {
        return this.getState().getOpenKey(this, invalid);
    }

    K getKey() {
        return this.clone(this.key);
    }

    public void setKey(@CheckForNull K key) {
        this.getState().setKey(this, key);
    }

    private void setKeyImpl(@CheckForNull K newKey) {
        K oldKey = this.key;
        this.key = this.clone(newKey);
        this.reset(oldKey);
        this.reset(newKey);
    }

    boolean isChangeKeySelected() {
        return this.changeKeySelected;
    }

    public void setChangeKeySelected(boolean changeKeySelected) {
        this.changeKeySelected = changeKeySelected;
    }

    public void resetCancelledKey() {
        this.getState().resetCancelledKey(this);
    }

    public void resetUnconditionally() {
        this.reset();
    }

    private void reset() {
        this.setState(State.RESET);
        this.reset(this.key);
    }

    @DefaultAnnotation(value={NonNull.class})
    static enum State {
        RESET{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            <K extends SafeKey<K>> K getCreateKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                State state;
                try {
                    provider.getUI().promptCreateKey(provider);
                }
                finally {
                    state = provider.getState();
                    if (state == this) {
                        state = CANCELLED;
                        ((PromptingKeyProvider)provider).setState(state);
                    }
                }
                return state.getCreateKey(provider);
            }

            @Override
            <K extends SafeKey<K>> K getOpenKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                State state;
                do {
                    try {
                        provider.getUI().promptOpenKey(provider, invalid);
                    }
                    catch (KeyPromptingCancelledException ex) {
                        ((PromptingKeyProvider)provider).setState(1.CANCELLED);
                        throw ex;
                    }
                } while ((state = provider.getState()) == this);
                return state.getOpenKey(provider, false);
            }

            @Override
            <K extends SafeKey<K>> void setKey(PromptingKeyProvider<K> provider, K key) {
                ((PromptingKeyProvider)provider).setKeyImpl(key);
                ((PromptingKeyProvider)provider).setState(null != key ? 1.PROVIDED : 1.CANCELLED);
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
            }
        }
        ,
        PROVIDED{

            @Override
            <K extends SafeKey<K>> K getCreateKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                if (provider.isChangeKeySelected()) {
                    provider.setChangeKeySelected(false);
                    return RESET.getCreateKey(provider);
                }
                return provider.getKey();
            }

            @Override
            <K extends SafeKey<K>> K getOpenKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                if (invalid) {
                    ((PromptingKeyProvider)provider).setState(2.RESET);
                    return RESET.getOpenKey(provider, true);
                }
                return provider.getKey();
            }

            @Override
            <K extends SafeKey<K>> void setKey(PromptingKeyProvider<K> provider, K key) {
                throw new IllegalStateException(this.toString());
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
            }
        }
        ,
        CANCELLED{

            @Override
            <K extends SafeKey<K>> K getCreateKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                throw new KeyPromptingCancelledException();
            }

            @Override
            <K extends SafeKey<K>> K getOpenKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                throw new KeyPromptingCancelledException();
            }

            @Override
            <K extends SafeKey<K>> void setKey(PromptingKeyProvider<K> provider, K key) {
                throw new IllegalStateException(this.toString());
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
                ((PromptingKeyProvider)provider).reset();
            }
        };


        abstract <K extends SafeKey<K>> K getCreateKey(PromptingKeyProvider<K> var1) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> K getOpenKey(PromptingKeyProvider<K> var1, boolean var2) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void setKey(PromptingKeyProvider<K> var1, @CheckForNull K var2);

        abstract <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> var1);
    }

    @DefaultAnnotation(value={NonNull.class})
    public static interface UI<K extends SafeKey<K>> {
        public void promptCreateKey(PromptingKeyProvider<? super K> var1) throws UnknownKeyException;

        public void promptOpenKey(PromptingKeyProvider<? super K> var1, boolean var2) throws UnknownKeyException;
    }
}

