/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyProvider;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class SafeKeyManager<K extends SafeKey<K>, P extends SafeKeyProvider<K>>
implements KeyManager<K, P> {
    private final Map<URI, P> providers = new HashMap<URI, P>();
    private final KeyProvider.Factory<? extends K, ? extends P> factory;

    public SafeKeyManager(KeyProvider.Factory<? extends K, ? extends P> factory) {
        if (null == factory) {
            throw new NullPointerException();
        }
        this.factory = factory;
    }

    @Override
    public synchronized P getKeyProvider(URI resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.get(resource);
        if (null == provider) {
            provider = (SafeKeyProvider)this.factory.newKeyProvider();
            this.providers.put(resource, provider);
        }
        return (P)provider;
    }

    P findKeyProvider(URI resource) {
        return (P)((SafeKeyProvider)this.providers.get(resource));
    }

    @Override
    public synchronized boolean moveKeyProvider(URI oldResource, URI newResource) {
        if (oldResource.equals(newResource)) {
            return false;
        }
        if (null == newResource) {
            throw new NullPointerException();
        }
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.remove(oldResource);
        if (null != provider) {
            this.providers.put(newResource, provider);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeKeyProvider(URI resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        return null != this.providers.remove(resource);
    }
}

