/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.ThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@ThreadSafe
public class SafeKeyProvider<K extends SafeKey<K>>
implements KeyProvider<K> {
    public static final int MIN_KEY_RETRY_DELAY = 3000;
    private final ThreadLocal<Long> invalidated = new ThreadLocal<Long>(){

        @Override
        public Long initialValue() {
            return 0L;
        }
    };

    protected SafeKeyProvider() {
    }

    @Override
    public final K getCreateKey() throws UnknownKeyException {
        K key = this.getCreateKeyImpl();
        if (null == key) {
            throw new UnknownKeyException();
        }
        return this.clone(key);
    }

    @CheckForNull
    protected K getCreateKeyImpl() throws UnknownKeyException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final K getOpenKey(boolean invalid) throws UnknownKeyException {
        if (invalid) {
            this.invalidated.set(System.currentTimeMillis());
        }
        try {
            K key = this.getOpenKeyImpl(invalid);
            if (null == key) {
                throw new UnknownKeyException();
            }
            K k = this.clone(key);
            return k;
        }
        finally {
            this.enforceSuspensionPenalty();
        }
    }

    @CheckForNull
    protected K getOpenKeyImpl(boolean invalid) throws UnknownKeyException {
        return null;
    }

    @Nullable
    protected K clone(@CheckForNull K key) {
        return (K)(null == key ? null : (SafeKey)key.clone());
    }

    protected void reset(@CheckForNull K key) {
        if (null != key) {
            key.reset();
        }
    }

    private void enforceSuspensionPenalty() {
        long delay;
        long last = this.invalidated.get();
        InterruptedException interrupted = null;
        while ((delay = System.currentTimeMillis() - last) < 3000L) {
            try {
                Thread.sleep(3000L - delay);
            }
            catch (InterruptedException ex) {
                interrupted = ex;
            }
        }
        if (interrupted != null) {
            Thread.currentThread().interrupt();
        }
    }
}

