/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.sl;

import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerService;
import de.schlichtherle.truezip.key.spi.KeyManagerProvider;
import de.schlichtherle.truezip.util.ServiceLocator;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class KeyManagerLocator
implements KeyManagerService {
    public static final KeyManagerLocator SINGLETON = new KeyManagerLocator();
    private final KeyManagerService provider;

    private KeyManagerLocator() {
        ServiceLocator locator = new ServiceLocator(KeyManagerLocator.class.getClassLoader());
        KeyManagerProvider provider = (KeyManagerProvider)locator.getService(KeyManagerProvider.class, null);
        if (null == provider) {
            Iterator i = locator.getServices(KeyManagerProvider.class);
            if (i.hasNext()) {
                provider = (KeyManagerProvider)i.next();
            } else {
                throw new ServiceConfigurationError("No service provider available for " + KeyManagerProvider.class);
            }
        }
        this.provider = provider;
        Logger.getLogger(KeyManagerLocator.class.getName(), KeyManagerLocator.class.getName()).log(Level.CONFIG, "located", provider);
    }

    @Override
    public <K> KeyManager<? extends K, ?> getManager(Class<K> type) {
        return this.provider.getManager(type);
    }
}

