/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.ThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@ThreadSafe
public abstract class SafeKeyProvider<K extends SafeKey<K>>
implements KeyProvider<K> {
    public static final int MIN_KEY_RETRY_DELAY = 3000;
    private final ThreadLocal<Long> invalidated = new ThreadLocalLong();

    protected SafeKeyProvider() {
    }

    @Override
    public final K getWriteKey() throws UnknownKeyException {
        K key = this.getWriteKeyImpl();
        if (null == key) {
            throw new UnknownKeyException();
        }
        return SafeKeyProvider.clone(key);
    }

    @CheckForNull
    protected abstract K getWriteKeyImpl() throws UnknownKeyException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final K getReadKey(boolean invalid) throws UnknownKeyException {
        if (invalid) {
            this.invalidated.set(System.currentTimeMillis());
        }
        try {
            K key = this.getReadKeyImpl(invalid);
            if (null == key) {
                throw new UnknownKeyException();
            }
            K k = SafeKeyProvider.clone(key);
            return k;
        }
        finally {
            this.enforceSuspensionPenalty();
        }
    }

    @CheckForNull
    protected abstract K getReadKeyImpl(boolean var1) throws UnknownKeyException;

    @Nullable
    protected static <K extends SafeKey<K>> K clone(@CheckForNull K key) {
        return (K)(null == key ? null : (SafeKey)key.clone());
    }

    protected static <K extends SafeKey<K>> void reset(@CheckForNull K key) {
        if (null != key) {
            key.reset();
        }
    }

    private void enforceSuspensionPenalty() {
        long delay;
        long last = this.invalidated.get();
        InterruptedException interrupted = null;
        while ((delay = System.currentTimeMillis() - last) < 3000L) {
            try {
                Thread.sleep(3000L - delay);
            }
            catch (InterruptedException ex) {
                interrupted = ex;
            }
        }
        if (interrupted != null) {
            Thread.currentThread().interrupt();
        }
    }

    private static final class ThreadLocalLong
    extends ThreadLocal<Long> {
        private ThreadLocalLong() {
        }

        @Override
        public Long initialValue() {
            return 0L;
        }
    }
}

