/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.console;

import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import java.io.Console;
import java.net.URI;
import java.util.Arrays;
import java.util.ResourceBundle;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class AesCipherParametersView
implements PromptingKeyProvider.View<AesCipherParameters> {
    private static final String CLASS_NAME = AesCipherParametersView.class.getName();
    static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    static final Console con = System.console();
    private static final PromptingLock lock = new PromptingLock();
    private static final int MIN_PASSWD_LEN = 6;
    private static URI lastResource = URI.create("");
    private static final String YES = resources.getString("yes");
    private static final String NO = resources.getString("no");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void promptWriteKey(PromptingKeyProvider.Controller<AesCipherParameters> controller) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            URI resource = controller.getResource();
            assert (null != resource);
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("writeKey.banner"), resource);
            }
            lastResource = resource;
            AesCipherParameters param = controller.getKey();
            if (null == param) {
                param = new AesCipherParameters();
            }
            while (true) {
                char[] newPasswd1;
                if (null == (newPasswd1 = con.readPassword(resources.getString("writeKey.newPasswd1"), new Object[0])) || 0 >= newPasswd1.length) {
                    return;
                }
                try {
                    char[] newPasswd2;
                    block30: {
                        block29: {
                            newPasswd2 = con.readPassword(resources.getString("writeKey.newPasswd2"), new Object[0]);
                            if (newPasswd2 == null) {
                                return;
                            }
                            try {
                                if (Arrays.equals(newPasswd1, newPasswd2)) break block29;
                                con.printf(resources.getString("writeKey.passwd.noMatch"), new Object[0]);
                            }
                            catch (Throwable throwable) {
                                Arrays.fill(newPasswd2, '\u0000');
                                throw throwable;
                            }
                            Arrays.fill(newPasswd2, '\u0000');
                            continue;
                        }
                        if (newPasswd1.length >= 6) break block30;
                        con.printf(resources.getString("writeKey.passwd.tooShort"), new Object[0]);
                        Arrays.fill(newPasswd2, '\u0000');
                        continue;
                    }
                    param.setPassword(newPasswd1);
                    Arrays.fill(newPasswd2, '\u0000');
                }
                finally {
                    Arrays.fill(newPasswd1, '\u0000');
                    continue;
                }
                break;
            }
            con.printf(resources.getString("keyStrength.banner"), new Object[0]);
            con.printf(resources.getString("keyStrength.medium"), new Object[0]);
            con.printf(resources.getString("keyStrength.high"), new Object[0]);
            con.printf(resources.getString("keyStrength.ultra"), new Object[0]);
            block22: while (true) {
                String keyStrength;
                if (null == (keyStrength = con.readLine(resources.getString("keyStrength.prompt"), controller)) || keyStrength.length() <= 0) {
                    return;
                }
                try {
                    switch (Integer.parseInt(keyStrength)) {
                        case 128: {
                            param.setKeyStrength(Type0RaesParameters.KeyStrength.BITS_128);
                            break block22;
                        }
                        case 192: {
                            param.setKeyStrength(Type0RaesParameters.KeyStrength.BITS_192);
                            break block22;
                        }
                        case 256: {
                            param.setKeyStrength(Type0RaesParameters.KeyStrength.BITS_256);
                            break block22;
                        }
                    }
                }
                catch (NumberFormatException syntaxError) {}
            }
            controller.setKey(param);
        }
    }

    @Override
    public void promptReadKey(PromptingKeyProvider.Controller<AesCipherParameters> controller, boolean invalid) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            String changeKey;
            if (invalid) {
                con.printf(resources.getString("readKey.invalid"), new Object[0]);
            }
            URI resource = controller.getResource();
            assert (null != resource);
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("readKey.banner"), resource);
            }
            lastResource = resource;
            char[] passwd = con.readPassword(resources.getString("readKey.passwd"), new Object[0]);
            if (null == passwd || passwd.length <= 0) {
                controller.setKey(null);
                return;
            }
            AesCipherParameters param = new AesCipherParameters();
            param.setPassword(passwd);
            Arrays.fill(passwd, '\u0000');
            controller.setKey(param);
            do {
                changeKey = con.readLine(resources.getString("readKey.change"), new Object[0]);
                controller.setChangeRequested(YES.equalsIgnoreCase(changeKey));
            } while (null != changeKey && changeKey.length() > 0 && !YES.equalsIgnoreCase(changeKey) && !NO.equalsIgnoreCase(changeKey));
            return;
        }
    }

    private static class PromptingLock {
        private PromptingLock() {
        }
    }
}

