/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.swing;

import de.schlichtherle.truezip.io.swing.FileComboBoxBrowser;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

@DefaultAnnotation(value={NonNull.class})
public class AuthenticationPanel
extends JPanel {
    private static final long serialVersionUID = 3876515923659236921L;
    private static final String CLASS_NAME = AuthenticationPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final File BASE_DIR = FileSystemView.getFileSystemView().getDefaultDirectory();
    static final int AUTH_PASSWD = 0;
    static final int AUTH_KEY_FILE = 1;
    private final JComboBox keyFile = new JComboBox();
    private final JButton keyFileChooser = new JButton();
    private final EnhancedPanel keyFilePanel = new EnhancedPanel();
    private JTabbedPane tabs;

    public AuthenticationPanel() {
        this.initComponents();
        new FileComboBoxBrowser(this.keyFile).setDirectory(BASE_DIR);
        ((JTextField)this.keyFile.getEditor().getEditorComponent()).setColumns(30);
    }

    public void setPasswdPanel(JPanel passwdPanel) {
        if (passwdPanel == null) {
            throw new NullPointerException();
        }
        passwdPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String title = resources.getString("tab.passwd");
        if (title.equals(this.tabs.getTitleAt(0))) {
            this.tabs.removeTabAt(0);
        }
        this.tabs.insertTab(title, null, passwdPanel, null, 0);
        this.tabs.setSelectedIndex(0);
        this.revalidate();
    }

    Document getKeyFileDocument() {
        return ((JTextComponent)this.keyFile.getEditor().getEditorComponent()).getDocument();
    }

    public File getKeyFile() {
        return new File((String)this.keyFile.getSelectedItem());
    }

    private void setKeyFile(File file) {
        String oldPath = (String)this.keyFile.getSelectedItem();
        if (file.getPath().equals(oldPath)) {
            return;
        }
        this.keyFile.setSelectedItem(file.getPath());
    }

    public int getAuthenticationMethod() {
        int method = this.tabs.getSelectedIndex();
        switch (method) {
            case 0: {
                assert (resources.getString("tab.passwd").equals(this.tabs.getTitleAt(method)));
                break;
            }
            case 1: {
                assert (resources.getString("tab.keyFile").equals(this.tabs.getTitleAt(method)));
                break;
            }
            default: {
                throw new AssertionError((Object)"Unsupported authentication method!");
            }
        }
        return method;
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        JLabel keyFileLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyFilePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.keyFilePanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                AuthenticationPanel.this.keyFilePanelAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.keyFilePanel.setLayout((LayoutManager)new GridBagLayout());
        keyFileLabel.setDisplayedMnemonic(resources.getString("keyFile").charAt(0));
        keyFileLabel.setLabelFor(this.keyFile);
        keyFileLabel.setText(resources.getString("keyFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.keyFilePanel.add((Component)keyFileLabel, (Object)gridBagConstraints);
        this.keyFile.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.keyFilePanel.add((Component)this.keyFile, (Object)gridBagConstraints);
        this.keyFileChooser.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        this.keyFileChooser.setToolTipText(resources.getString("selectKeyFile.toolTip"));
        this.keyFileChooser.setName("keyFileChooser");
        this.keyFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationPanel.this.keyFileChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.keyFilePanel.add((Component)this.keyFileChooser, (Object)gridBagConstraints);
        this.tabs.addTab(resources.getString("tab.keyFile"), (Component)this.keyFilePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabs, gridBagConstraints);
    }

    private void keyFileChooserActionPerformed(ActionEvent evt) {
        CustomFileChooser fc = new CustomFileChooser();
        if (0 == fc.showOpenDialog(this)) {
            File file = fc.getSelectedFile();
            try {
                String filePath = file.getCanonicalPath();
                String userDirPath = BASE_DIR.getPath();
                if (filePath.startsWith(userDirPath)) {
                    file = new File(filePath.substring(userDirPath.length() + 1));
                }
                this.setKeyFile(file);
            }
            catch (IOException ex) {
                Logger.getLogger(CLASS_NAME).log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
        }
    }

    private void keyFilePanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AuthenticationPanel.this.keyFile.requestFocusInWindow()) {
                            ((JTextComponent)AuthenticationPanel.this.keyFile.getEditor().getEditorComponent()).selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }

    private static class CustomFileChooser
    extends JFileChooser {
        private static final long serialVersionUID = 2361832976537648223L;

        public CustomFileChooser() {
            super(BASE_DIR);
            this.setDialogTitle(resources.getString("fileChooser.title"));
            this.setFileHidingEnabled(false);
        }
    }
}

