/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyProvider;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class SafeKeyManager<K extends SafeKey<K>, P extends SafeKeyProvider<K>>
implements KeyManager<K> {
    private final Map<URI, P> providers = new HashMap<URI, P>();
    private final KeyProvider.Factory<? extends P> factory;

    public SafeKeyManager(KeyProvider.Factory<? extends P> factory) {
        if (null == factory) {
            throw new NullPointerException();
        }
        this.factory = factory;
    }

    public synchronized P getKeyProvider(URI resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.get(resource);
        if (null == provider) {
            provider = (SafeKeyProvider)this.factory.newKeyProvider();
            this.providers.put(resource, provider);
        }
        return (P)provider;
    }

    public synchronized P moveKeyProvider(URI oldResource, URI newResource) {
        if (null == newResource) {
            throw new NullPointerException();
        }
        if (oldResource.equals(newResource)) {
            throw new IllegalArgumentException();
        }
        return (P)((SafeKeyProvider)this.providers.put(newResource, this.removeKeyProvider0(oldResource)));
    }

    public synchronized P removeKeyProvider(URI resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        return this.removeKeyProvider0(resource);
    }

    private P removeKeyProvider0(URI resource) {
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.remove(resource);
        if (null == provider) {
            throw new IllegalArgumentException();
        }
        return (P)provider;
    }
}

