/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.junit.Assert;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class MockType0RaesParameters
implements Type0RaesParameters {
    private static final Logger logger = Logger.getLogger(MockType0RaesParameters.class.getName());
    private static final String PASSWD = "secret";
    private static final Type0RaesParameters.KeyStrength[] keyStrengths = Type0RaesParameters.KeyStrength.values();
    private final Random rnd = new Random();
    private boolean secondTry;
    private Type0RaesParameters.KeyStrength keyStrength;

    public char[] getWritePassword() {
        return PASSWD.toCharArray();
    }

    public char[] getReadPassword(boolean invalid) {
        Assert.assertTrue((this.secondTry || !invalid ? 1 : 0) != 0);
        if (this.secondTry) {
            logger.finer("First returned password was wrong, providing the right one now!");
            return PASSWD.toCharArray();
        }
        this.secondTry = true;
        byte[] buf = new byte[1];
        this.rnd.nextBytes(buf);
        return buf[0] >= 0 ? PASSWD.toCharArray() : "wrong".toCharArray();
    }

    public Type0RaesParameters.KeyStrength getKeyStrength() {
        this.keyStrength = keyStrengths[this.rnd.nextInt(keyStrengths.length)];
        logger.log(Level.FINE, "Using {0} bits cipher key.", 128 + 64 * this.keyStrength.ordinal());
        return this.keyStrength;
    }

    public void setKeyStrength(Type0RaesParameters.KeyStrength keyStrength) {
        Assert.assertTrue((null == this.keyStrength || this.keyStrength == keyStrength ? 1 : 0) != 0);
    }
}

