/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileTestSuite;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.zip.raes.PromptingKeyManagerService;
import de.schlichtherle.truezip.fs.archive.zip.raes.SafeZipRaesDriver;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesDriver;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.MockView;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public final class TZipRaesFileTest
extends TFileTestSuite {
    private static final MockView<AesCipherParameters> view = new MockView();

    public TZipRaesFileTest() {
        super(FsScheme.create((String)"tzp"), (FsArchiveDriver)new SafeZipRaesDriver(IO_POOL_PROVIDER, (KeyManagerProvider)new PromptingKeyManagerService(view)){

            public ZipRaesDriver.KeyProviderSyncStrategy getKeyProviderSyncStrategy() {
                return ZipRaesDriver.KeyProviderSyncStrategy.RESET_UNCONDITIONALLY;
            }
        });
    }

    public void setUp() throws IOException {
        AesCipherParameters key = new AesCipherParameters();
        key.setPassword("secret".toCharArray());
        view.setKey(key);
        view.setAction(MockView.Action.ENTER);
        super.setUp();
    }

    @Test
    public void testCancelling() throws IOException {
        view.setAction(MockView.Action.CANCEL);
        TFile archive = new TFile(this.getArchive().getPath());
        TFile entry1 = new TFile((File)archive, "entry1");
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        Assert.assertFalse((boolean)entry1.mkdirs());
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        try {
            Assert.assertFalse((boolean)entry1.createNewFile());
            Assert.fail((String)"An IOException should have been thrown because password prompting has been disabled!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        TFile entry2 = new TFile((File)entry1, "entry2");
        Assert.assertFalse((boolean)entry2.mkdirs());
        Assert.assertFalse((boolean)new File(entry2.getPath()).exists());
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
        try {
            Assert.assertFalse((boolean)entry2.createNewFile());
            Assert.fail((String)"An IOException should have been thrown because password prompting has been disabled!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)new File(entry2.getPath()).exists());
        Assert.assertFalse((boolean)new File(entry1.getPath()).exists());
        Assert.assertFalse((boolean)new File(archive.getPath()).exists());
    }

    @Test
    public void testFileStatus() throws IOException {
        TFile archive = this.getArchive();
        TFile inner = new TFile((File)archive, "inner" + this.getSuffix());
        Assert.assertTrue((boolean)archive.mkdir());
        Assert.assertTrue((boolean)inner.mkdir());
        TFile.umount();
        view.setAction(MockView.Action.CANCEL);
        Assert.assertTrue((boolean)archive.exists());
        Assert.assertFalse((boolean)archive.isDirectory());
        Assert.assertFalse((boolean)archive.isFile());
        TFile.umount();
        view.setAction(MockView.Action.ENTER);
        Assert.assertTrue((boolean)archive.exists());
        Assert.assertTrue((boolean)archive.isDirectory());
        Assert.assertFalse((boolean)archive.isFile());
        view.setAction(MockView.Action.CANCEL);
        Assert.assertTrue((boolean)inner.exists());
        Assert.assertFalse((boolean)inner.isDirectory());
        Assert.assertFalse((boolean)inner.isFile());
        TFile.umount();
        try {
            archive.rm_r();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TFile.umount();
        view.setAction(MockView.Action.ENTER);
        archive.rm_r();
    }
}

