/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyPromptingCancelledException;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import java.net.URI;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class MockView<K extends SafeKey<K>>
implements PromptingKeyProvider.View<K> {
    private volatile Action action = Action.ENTER;
    private volatile URI resource;
    private volatile K key;
    private volatile boolean changeRequested;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (null == action) {
            throw new NullPointerException();
        }
        this.action = action;
    }

    public URI getResource() {
        return this.resource;
    }

    public void setResource(URI resource) {
        this.resource = resource;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public boolean isChangeRequested() {
        return this.changeRequested;
    }

    public void setChangeRequested(boolean changeRequested) {
        this.changeRequested = changeRequested;
    }

    public synchronized void promptWriteKey(PromptingKeyProvider.Controller<K> controller) throws UnknownKeyException {
        URI resource = this.resource;
        if (null != resource && !resource.equals(controller.getResource())) {
            throw new IllegalArgumentException();
        }
        controller.getKey();
        try {
            controller.setChangeRequested(true);
            throw new IllegalArgumentException();
        }
        catch (IllegalStateException expected) {
            try {
                controller.setChangeRequested(false);
                throw new IllegalArgumentException();
            }
            catch (IllegalStateException illegalStateException) {
                this.action.promptWriteKey(controller, this.key);
                return;
            }
        }
    }

    public synchronized void promptReadKey(PromptingKeyProvider.Controller<K> controller, boolean invalid) throws UnknownKeyException {
        URI resource = this.resource;
        if (null != resource && !resource.equals(controller.getResource())) {
            throw new IllegalArgumentException();
        }
        try {
            controller.getKey();
            throw new IllegalArgumentException();
        }
        catch (IllegalStateException expected) {
            this.action.promptReadKey(controller, this.key, this.changeRequested);
            return;
        }
    }

    public static enum Action {
        ENTER{

            @Override
            <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> controller, K key) throws UnknownKeyException {
                controller.setKey(null);
                controller.setKey(null != key ? (SafeKey)key.clone() : null);
            }

            @Override
            <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> controller, K key, boolean changeRequested) throws UnknownKeyException {
                controller.setKey(null);
                controller.setChangeRequested(false);
                controller.setChangeRequested(true);
                controller.setKey(null != key ? (SafeKey)key.clone() : null);
                controller.setChangeRequested(changeRequested);
            }
        }
        ,
        CANCEL{
            private final Random rnd = new Random();

            @Override
            <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> controller, K key) throws UnknownKeyException {
                if (this.rnd.nextBoolean()) {
                    throw new KeyPromptingCancelledException();
                }
                controller.setKey(null);
            }

            @Override
            <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> controller, K key, boolean changeRequested) throws UnknownKeyException {
                if (this.rnd.nextBoolean()) {
                    throw new KeyPromptingCancelledException();
                }
                controller.setChangeRequested(false);
                controller.setKey(null);
                controller.setChangeRequested(true);
            }
        }
        ,
        IGNORE{

            @Override
            <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> controller, K key) throws UnknownKeyException {
            }

            @Override
            <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> controller, K key, boolean changeRequested) throws UnknownKeyException {
            }
        };


        abstract <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> var1, K var2) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> var1, K var2, boolean var3) throws UnknownKeyException;
    }
}

