/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.crypto.raes.param.console.AesCipherParametersView;
import de.schlichtherle.truezip.key.KeyManagerTestSuite;
import de.schlichtherle.truezip.key.PromptingKeyManager;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public class PromptingKeyManagerTest
extends KeyManagerTestSuite {
    protected PromptingKeyManager<?> newKeyManager() {
        return new PromptingKeyManager((PromptingKeyProvider.View)new AesCipherParametersView());
    }

    @Test
    public void testGetPromptingKeyProvider() {
        PromptingKeyManager<?> manager = this.newKeyManager();
        URI id = URI.create("a");
        PromptingKeyProvider prov = manager.getKeyProvider(id);
        Assert.assertSame((Object)id, (Object)prov.getResource());
    }

    @Test
    public void testMovePromptingKeyProvider() {
        PromptingKeyManager<?> manager = this.newKeyManager();
        URI idA = URI.create("a");
        URI idB = URI.create("b");
        PromptingKeyProvider prov = manager.getKeyProvider(idA);
        Assert.assertSame((Object)idA, (Object)prov.getResource());
        manager.moveKeyProvider(idA, idB);
        Assert.assertSame((Object)idB, (Object)prov.getResource());
    }

    @Test
    public void testRemovePromptingKeyProvider() {
        PromptingKeyManager<?> manager = this.newKeyManager();
        URI id = URI.create("a");
        PromptingKeyProvider prov = manager.getKeyProvider(id);
        Assert.assertSame((Object)id, (Object)prov.getResource());
        manager.removeKeyProvider(id);
        Assert.assertNull((Object)prov.getResource());
    }
}

