/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.DummyKey;
import de.schlichtherle.truezip.key.MockView;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import java.net.URI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PromptingKeyProviderTest {
    private static final URI RESOURCE = URI.create("foo");
    private MockView<DummyKey> view;
    private PromptingKeyProvider<DummyKey> provider;

    @Before
    public void setUp() {
        this.view = new MockView();
        this.view.setResource(RESOURCE);
        this.view.setChangeRequested(true);
        this.provider = new PromptingKeyProvider();
        this.provider.setView(this.view);
        this.provider.setResource(RESOURCE);
    }

    @Test
    public void testLifeCycle() throws UnknownKeyException {
        DummyKey key = new DummyKey();
        this.view.setKey(key);
        Assert.assertSame((Object)key, (Object)this.view.getKey());
        Assert.assertEquals((Object)key, (Object)this.provider.getWriteKey());
        Assert.assertEquals((Object)key, (Object)this.provider.getReadKey(false));
        this.view.setAction(MockView.Action.CANCEL);
        Assert.assertEquals((Object)key, (Object)this.provider.getWriteKey());
        Assert.assertEquals((Object)key, (Object)this.provider.getReadKey(false));
        this.provider.resetCancelledKey();
        Assert.assertEquals((Object)key, (Object)this.provider.getReadKey(false));
        Assert.assertEquals((Object)key, (Object)this.provider.getWriteKey());
        this.provider.resetUnconditionally();
        key = new DummyKey();
        this.view.setKey(key);
        try {
            this.provider.getReadKey(false);
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        key = new DummyKey();
        this.view.setKey(key);
        try {
            this.provider.getWriteKey();
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        this.view.setAction(MockView.Action.IGNORE);
        key = new DummyKey();
        this.view.setKey(key);
        try {
            this.provider.getReadKey(false);
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        key = new DummyKey();
        this.view.setKey(key);
        try {
            this.provider.getWriteKey();
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        this.provider.resetCancelledKey();
        this.view.setAction(MockView.Action.ENTER);
        key = new DummyKey();
        this.view.setKey(key);
        Assert.assertEquals((Object)key, (Object)this.provider.getReadKey(false));
        key = new DummyKey();
        this.view.setKey(key);
        Assert.assertEquals((Object)key, (Object)this.provider.getWriteKey());
        this.provider.setKey(null);
        try {
            this.provider.getReadKey(false);
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        try {
            this.provider.getWriteKey();
            Assert.fail();
        }
        catch (UnknownKeyException unknownKeyException) {
            // empty catch block
        }
        key = new DummyKey();
        this.provider.setKey((SafeKey)key);
        Assert.assertEquals((Object)key, (Object)this.provider.getReadKey(false));
        this.view.setKey(new DummyKey());
        Assert.assertEquals((Object)key, (Object)this.provider.getWriteKey());
    }
}

