/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.raes.MockType0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import de.schlichtherle.truezip.zip.ZipTestSuite;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class RaesZipTest
extends ZipTestSuite {
    private static int AUTHENTICATION_TRIGGER = 524288;
    private static final RaesParameters raesParameters = new MockType0RaesParameters();

    protected ZipOutputStream newZipOutputStream(OutputStream out) throws IOException {
        RaesOutputStream ros = RaesOutputStream.getInstance((OutputStream)out, (RaesParameters)raesParameters);
        try {
            return new ZipOutputStream((OutputStream)ros);
        }
        catch (RuntimeException exc) {
            ros.close();
            throw exc;
        }
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out, Charset cs) throws IOException {
        RaesOutputStream ros = RaesOutputStream.getInstance((OutputStream)out, (RaesParameters)raesParameters);
        try {
            return new ZipOutputStream((OutputStream)ros, cs);
        }
        catch (RuntimeException exc) {
            ros.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(String name) throws IOException {
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)new File(name), (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(String name, Charset cs) throws IOException {
        if (null == cs) {
            throw new NullPointerException();
        }
        new String(new byte[0], cs);
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)new File(name), (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof, cs);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(File file) throws IOException {
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)file, (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(File file, Charset charset) throws IOException {
        if (null == charset) {
            throw new NullPointerException();
        }
        new String(new byte[0], charset);
        RaesReadOnlyFile rof = RaesReadOnlyFile.getInstance((File)file, (RaesParameters)raesParameters);
        try {
            if (rof.length() < (long)AUTHENTICATION_TRIGGER) {
                rof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rof, charset);
        }
        catch (RuntimeException exc) {
            rof.close();
            throw exc;
        }
        catch (IOException exc) {
            rof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(ReadOnlyFile rof) throws IOException {
        RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance((ReadOnlyFile)rof, (RaesParameters)raesParameters);
        try {
            if (rrof.length() < (long)AUTHENTICATION_TRIGGER) {
                rrof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rrof);
        }
        catch (RuntimeException exc) {
            rrof.close();
            throw exc;
        }
        catch (IOException exc) {
            rrof.close();
            throw exc;
        }
    }

    protected ZipFile newZipFile(ReadOnlyFile rof, Charset cs) throws IOException {
        if (null == cs) {
            throw new NullPointerException();
        }
        new String(new byte[0], cs);
        RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance((ReadOnlyFile)rof, (RaesParameters)raesParameters);
        try {
            if (rrof.length() < (long)AUTHENTICATION_TRIGGER) {
                rrof.authenticate();
            }
            return new ZipFile((ReadOnlyFile)rrof, cs);
        }
        catch (RuntimeException exc) {
            rrof.close();
            throw exc;
        }
        catch (IOException exc) {
            rrof.close();
            throw exc;
        }
    }
}

