/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.KeyManagerRaesParameters;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.zip.JarArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesController;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.LazyOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public abstract class ZipRaesDriver
extends JarDriver {
    private final KeyManagerProvider keyManagerProvider;

    public ZipRaesDriver(IOPoolProvider ioPoolProvider, KeyManagerProvider keyManagerProvider) {
        super(ioPoolProvider);
        if (null == keyManagerProvider) {
            throw new NullPointerException();
        }
        this.keyManagerProvider = keyManagerProvider;
    }

    public KeyProviderSyncStrategy getKeyProviderSyncStrategy() {
        return KeyProviderSyncStrategy.RESET_CANCELLED_KEY;
    }

    public abstract long getAuthenticationTrigger();

    public final FsController<?> newController(FsModel model, FsController<?> parent) {
        return new ZipRaesController(super.newController(model, parent), this);
    }

    public final JarArchiveEntry newEntry(String path, Entry.Type type, @CheckForNull Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        return super.newEntry(path, type, template, mknod.set((Enum)FsOutputOption.COMPRESS));
    }

    public final ZipInputShop newInputShop(final FsModel model, final InputSocket<?> target) throws IOException {
        class Input
        extends DecoratingInputSocket<Entry> {
            Input() {
                super(inputSocket);
            }

            public ReadOnlyFile newReadOnlyFile() throws IOException {
                ReadOnlyFile rof = super.newReadOnlyFile();
                try {
                    RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance(rof, ZipRaesDriver.this.getRaesParameters(model));
                    if (rof.length() <= ZipRaesDriver.this.getAuthenticationTrigger()) {
                        rrof.authenticate();
                    }
                    return rrof;
                }
                catch (IOException ex) {
                    rof.close();
                    throw ex;
                }
            }

            public InputStream newInputStream() throws IOException {
                throw new UnsupportedOperationException();
            }
        }
        return super.newInputShop(model, (InputSocket)new Input());
    }

    public OutputShop<ZipArchiveEntry> newOutputShop(final FsModel model, final OutputSocket<?> target, @CheckForNull InputShop<ZipArchiveEntry> source) throws IOException {
        class Output
        extends DecoratingOutputSocket<Entry> {
            Output() {
                super(outputSocket);
            }

            public OutputStream newOutputStream() throws IOException {
                OutputStream out = new LazyOutputSocket(this.getBoundSocket()).newOutputStream();
                try {
                    return RaesOutputStream.getInstance(out, ZipRaesDriver.this.getRaesParameters(model));
                }
                catch (IOException cause) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        throw (IOException)ex.initCause(cause);
                    }
                    throw cause;
                }
            }
        }
        return super.newOutputShop(model, (OutputSocket)new Output(), source);
    }

    final RaesParameters getRaesParameters(FsModel model) {
        return new KeyManagerRaesParameters(this.getKeyManager(), this.toMountPointResource(model));
    }

    final KeyManager<AesCipherParameters> getKeyManager() {
        return this.keyManagerProvider.get(AesCipherParameters.class);
    }

    protected URI toMountPointResource(FsModel model) {
        return model.getMountPoint().getHierarchicalUri();
    }

    public static enum KeyProviderSyncStrategy {
        RESET_CANCELLED_KEY{

            @Override
            public void sync(KeyProvider<?> provider) {
                if (provider instanceof PromptingKeyProvider) {
                    ((PromptingKeyProvider)provider).resetCancelledKey();
                }
            }
        }
        ,
        RESET_UNCONDITIONALLY{

            @Override
            public void sync(KeyProvider<?> provider) {
                if (provider instanceof PromptingKeyProvider) {
                    ((PromptingKeyProvider)provider).resetUnconditionally();
                }
            }
        };


        public abstract void sync(KeyProvider<?> var1);
    }
}

