/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param;

import de.schlichtherle.truezip.crypto.raes.RaesKeyException;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesParametersProvider;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;

@DefaultAnnotation(value={NonNull.class})
public final class KeyManagerRaesParameters
implements RaesParametersProvider {
    private final KeyManager<AesCipherParameters> manager;
    private final URI resource;

    public KeyManagerRaesParameters(KeyManagerProvider provider, URI resource) {
        this(provider.get(AesCipherParameters.class), resource);
    }

    public KeyManagerRaesParameters(KeyManager<AesCipherParameters> manager, URI resource) {
        if (null == manager) {
            throw new NullPointerException();
        }
        if (!resource.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        this.manager = manager;
        this.resource = resource;
    }

    @Override
    public <P extends RaesParameters> P get(Class<P> type) {
        return (P)(type.isAssignableFrom(Type0.class) ? new Type0() : null);
    }

    private class Type0
    implements Type0RaesParameters {
        private AesCipherParameters param;

        private Type0() {
        }

        @Override
        public char[] getWritePassword() throws RaesKeyException {
            KeyProvider provider = KeyManagerRaesParameters.this.manager.getKeyProvider(KeyManagerRaesParameters.this.resource);
            try {
                this.param = (AesCipherParameters)provider.getWriteKey();
                return this.param.getPassword();
            }
            catch (UnknownKeyException failure) {
                throw new RaesKeyException(failure);
            }
        }

        @Override
        public char[] getReadPassword(boolean invalid) throws RaesKeyException {
            KeyProvider provider = KeyManagerRaesParameters.this.manager.getKeyProvider(KeyManagerRaesParameters.this.resource);
            try {
                this.param = (AesCipherParameters)provider.getReadKey(invalid);
                return this.param.getPassword();
            }
            catch (UnknownKeyException failure) {
                throw new RaesKeyException(failure);
            }
        }

        @Override
        public Type0RaesParameters.KeyStrength getKeyStrength() {
            if (null == this.param) {
                throw new IllegalStateException("getWritePasswd() must get called first!");
            }
            return this.param.getKeyStrength();
        }

        @Override
        public void setKeyStrength(Type0RaesParameters.KeyStrength keyStrength) {
            if (null == this.param) {
                throw new IllegalStateException("getReadPasswd(boolean) must get called first!");
            }
            KeyProvider<AesCipherParameters> provider = KeyManagerRaesParameters.this.manager.getKeyProvider(KeyManagerRaesParameters.this.resource);
            this.param.setKeyStrength(keyStrength);
            provider.setKey(this.param);
        }
    }
}

