/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesKeyException;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesDriver;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class ZipRaesController
extends FsDecoratingController<FsModel, FsController<?>> {
    private static final String ROOT_PATH = FsEntryName.ROOT.getPath();
    private final ZipRaesDriver driver;

    ZipRaesController(FsController<?> controller, ZipRaesDriver driver) {
        super(controller);
        this.driver = driver;
    }

    public FsEntry getEntry(FsEntryName name) throws IOException {
        try {
            return this.delegate.getEntry(name);
        }
        catch (FsFalsePositiveException ex) {
            if (!(ex.getCause() instanceof RaesKeyException)) {
                throw ex;
            }
            if (!name.isRoot()) {
                return null;
            }
            FsEntry entry = this.getParent().getEntry(this.getModel().getMountPoint().getPath().resolve(name).getEntryName());
            assert (null != entry);
            while (entry instanceof FsCovariantEntry) {
                entry = ((FsCovariantEntry)entry).getEntry();
            }
            FsCovariantEntry special = new FsCovariantEntry(ROOT_PATH);
            special.putEntry(Entry.Type.SPECIAL, this.driver.newEntry(ROOT_PATH, Entry.Type.SPECIAL, (Entry)entry));
            return special;
        }
    }

    public void unlink(FsEntryName name) throws IOException {
        try {
            this.delegate.unlink(name);
        }
        catch (FsFalsePositiveException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof RaesKeyException ? (RaesKeyException)cause : ex;
        }
        if (name.isRoot()) {
            this.driver.getKeyManager().removeKeyProvider(this.driver.toMountPointResource(this.getModel()));
        }
    }

    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.delegate.sync(options, handler);
        this.driver.getKeyProviderSyncStrategy().sync(this.driver.getKeyManager().getKeyProvider(this.driver.toMountPointResource(this.getModel())));
    }
}

