/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyPromptingCancelledException;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class PromptingKeyProvider<K extends SafeKey<K>>
extends SafeKeyProvider<K> {
    @CheckForNull
    private volatile URI resource;
    @CheckForNull
    private volatile View<K> view;
    @NonNull
    private volatile State state = State.RESET;
    @CheckForNull
    private volatile K key;
    private volatile boolean changeRequested;

    public URI getResource() {
        return this.resource;
    }

    void setResource(URI resource) {
        this.resource = resource;
    }

    final View<K> getView() {
        return this.view;
    }

    final void setView(View<K> view) {
        this.view = view;
    }

    @NonNull
    private State getState() {
        return this.state;
    }

    private void setState(@NonNull State state) {
        this.state = state;
    }

    @Override
    protected final K getWriteKeyImpl() throws UnknownKeyException {
        return this.getState().getWriteKey(this);
    }

    @Override
    protected final K getReadKeyImpl(boolean invalid) throws UnknownKeyException {
        return this.getState().getReadKey(this, invalid);
    }

    @CheckForNull
    private K getKey() {
        return this.key;
    }

    @Override
    public void setKey(@CheckForNull K newKey) {
        K oldKey = this.key;
        this.key = PromptingKeyProvider.clone(newKey);
        this.setState(null != newKey ? State.PROVIDED : State.CANCELLED);
        PromptingKeyProvider.reset(oldKey);
    }

    private boolean isChangeRequested() {
        return this.changeRequested;
    }

    private void setChangeRequested(boolean changeRequested) {
        this.changeRequested = changeRequested;
    }

    public void resetCancelledKey() {
        this.getState().resetCancelledKey(this);
    }

    public void resetUnconditionally() {
        this.reset();
    }

    private void reset() {
        this.setKey((K)null);
        this.setChangeRequested(false);
        this.setState(State.RESET);
    }

    public static final class Factory<K extends SafeKey<K>>
    implements KeyProvider.Factory<PromptingKeyProvider<K>> {
        @Override
        public PromptingKeyProvider<K> newKeyProvider() {
            return new PromptingKeyProvider();
        }
    }

    private static class ReadController<K extends SafeKey<K>>
    extends Controller<K> {
        private ReadController(PromptingKeyProvider<K> provider, State state) {
            super(provider, state);
        }

        @Override
        public K getKey() {
            throw new IllegalStateException();
        }
    }

    private static class WriteController<K extends SafeKey<K>>
    extends Controller<K> {
        private WriteController(PromptingKeyProvider<K> provider, State state) {
            super(provider, state);
        }

        @Override
        public void setChangeRequested(boolean changeRequested) {
            throw new IllegalStateException();
        }
    }

    @ThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    public static class Controller<K extends SafeKey<K>> {
        private final PromptingKeyProvider<K> provider;
        @CheckForNull
        private State state;

        private Controller(PromptingKeyProvider<K> provider, State state) {
            this.provider = provider;
            this.state = state;
        }

        public URI getResource() {
            if (null == this.state) {
                throw new IllegalStateException();
            }
            return this.state.getResource(this.provider);
        }

        @CheckForNull
        public K getKey() {
            if (null == this.state) {
                throw new IllegalStateException();
            }
            return this.state.getKey(this.provider);
        }

        public void setKey(@CheckForNull K key) {
            if (null == this.state) {
                throw new IllegalStateException();
            }
            this.state.setKey(this.provider, key);
        }

        public void setChangeRequested(boolean changeRequested) {
            if (null == this.state) {
                throw new IllegalStateException();
            }
            this.state.setChangeRequested(this.provider, changeRequested);
        }

        private void invalidate() {
            this.state = null;
        }
    }

    @DefaultAnnotation(value={NonNull.class})
    public static interface View<K extends SafeKey<K>> {
        public void promptWriteKey(Controller<K> var1) throws UnknownKeyException;

        public void promptReadKey(Controller<K> var1, boolean var2) throws UnknownKeyException;
    }

    @ThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    static enum State {
        RESET{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            <K extends SafeKey<K>> K getWriteKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                State state;
                try {
                    WriteController controller = new WriteController(provider, this);
                    provider.getView().promptWriteKey(controller);
                    ((Controller)controller).invalidate();
                }
                finally {
                    state = ((PromptingKeyProvider)provider).getState();
                    if (state == this) {
                        state = CANCELLED;
                        ((PromptingKeyProvider)provider).setState(state);
                    }
                }
                return state.getWriteKey(provider);
            }

            @Override
            <K extends SafeKey<K>> K getReadKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                State state;
                do {
                    try {
                        ReadController controller = new ReadController(provider, this);
                        provider.getView().promptReadKey(controller, invalid);
                        ((Controller)controller).invalidate();
                    }
                    catch (KeyPromptingCancelledException ex) {
                        ((PromptingKeyProvider)provider).setState(1.CANCELLED);
                        throw ex;
                    }
                } while ((state = ((PromptingKeyProvider)provider).getState()) == this);
                return state.getReadKey(provider, false);
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
            }
        }
        ,
        PROVIDED{

            @Override
            <K extends SafeKey<K>> K getWriteKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                if (((PromptingKeyProvider)provider).isChangeRequested()) {
                    ((PromptingKeyProvider)provider).setChangeRequested(false);
                    return RESET.getWriteKey(provider);
                }
                return (K)((PromptingKeyProvider)provider).getKey();
            }

            @Override
            <K extends SafeKey<K>> K getReadKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                if (invalid) {
                    ((PromptingKeyProvider)provider).setState(2.RESET);
                    return RESET.getReadKey(provider, true);
                }
                return (K)((PromptingKeyProvider)provider).getKey();
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
            }
        }
        ,
        CANCELLED{

            @Override
            <K extends SafeKey<K>> K getWriteKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                throw new KeyPromptingCancelledException();
            }

            @Override
            <K extends SafeKey<K>> K getReadKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                throw new KeyPromptingCancelledException();
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
                ((PromptingKeyProvider)provider).reset();
            }
        };


        abstract <K extends SafeKey<K>> K getWriteKey(PromptingKeyProvider<K> var1) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> K getReadKey(PromptingKeyProvider<K> var1, boolean var2) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> var1);

        @CheckForNull
        <K extends SafeKey<K>> K getKey(PromptingKeyProvider<K> provider) {
            return (K)((PromptingKeyProvider)provider).getKey();
        }

        final <K extends SafeKey<K>> void setKey(PromptingKeyProvider<K> provider, K key) {
            provider.setKey(key);
        }

        <K extends SafeKey<K>> void setChangeRequested(PromptingKeyProvider<K> provider, boolean changeRequested) {
            ((PromptingKeyProvider)provider).setChangeRequested(changeRequested);
        }

        <K extends SafeKey<K>> URI getResource(PromptingKeyProvider<K> provider) {
            return provider.getResource();
        }
    }
}

