/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.swing;

import de.schlichtherle.truezip.awt.Windows;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.swing.AesKeyStrengthPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.BasicInvalidKeyFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.BasicUnknownKeyFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.InvalidKeyFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.ReadKeyPanel;
import de.schlichtherle.truezip.crypto.raes.param.swing.UnknownKeyFeedback;
import de.schlichtherle.truezip.crypto.raes.param.swing.WriteKeyPanel;
import de.schlichtherle.truezip.key.KeyPromptingInterruptedException;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public final class AesCipherParametersView
implements PromptingKeyProvider.View<AesCipherParameters> {
    private static final String CLASS_NAME = AesCipherParametersView.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    static final URI INITIAL_RESOURCE = URI.create("");
    public static final int KEY_FILE_LEN = 512;
    private static final Map<URI, ReadKeyPanel> readKeyPanels = new WeakHashMap<URI, ReadKeyPanel>();
    private static final ServiceLocator serviceLocator = new ServiceLocator(AesCipherParametersView.class.getClassLoader());
    static volatile URI lastResource = INITIAL_RESOURCE;
    private volatile UnknownKeyFeedback unknownKeyFeedback;
    private volatile InvalidKeyFeedback invalidKeyFeedback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readKeyFile(File file) throws IOException {
        byte[] buf = new byte[512];
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.readFully(buf);
        }
        finally {
            raf.close();
        }
        return buf;
    }

    UnknownKeyFeedback getUnknownKeyFeedback() {
        if (this.unknownKeyFeedback == null) {
            this.unknownKeyFeedback = (UnknownKeyFeedback)serviceLocator.getService(UnknownKeyFeedback.class, BasicUnknownKeyFeedback.class);
        }
        return this.unknownKeyFeedback;
    }

    void setUnkownKeyFeedback(UnknownKeyFeedback uckf) {
        this.unknownKeyFeedback = uckf;
    }

    InvalidKeyFeedback getInvalidKeyFeedback() {
        if (this.invalidKeyFeedback == null) {
            this.invalidKeyFeedback = (InvalidKeyFeedback)serviceLocator.getService(InvalidKeyFeedback.class, BasicInvalidKeyFeedback.class);
        }
        return this.invalidKeyFeedback;
    }

    void setInvalidKeyFeedback(InvalidKeyFeedback ickf) {
        this.invalidKeyFeedback = ickf;
    }

    @Override
    public void promptWriteKey(final PromptingKeyProvider.Controller<AesCipherParameters> controller) throws UnknownKeyException {
        class PromptWriteKey
        implements Runnable {
            PromptWriteKey() {
            }

            @Override
            public void run() {
                AesCipherParametersView.this.promptWriteKeyEDT(controller);
            }
        }
        AesCipherParametersView.multiplexOnEDT(new PromptWriteKey());
    }

    private void promptWriteKeyEDT(PromptingKeyProvider.Controller<AesCipherParameters> controller) {
        assert (EventQueue.isDispatchThread());
        URI resource = controller.getResource();
        assert (null != resource);
        AesCipherParameters param = controller.getKey();
        if (null == param) {
            param = new AesCipherParameters();
        }
        AesKeyStrengthPanel keyStrengthPanel = new AesKeyStrengthPanel();
        keyStrengthPanel.setKeyStrength(param.getKeyStrength());
        WriteKeyPanel keyPanel = new WriteKeyPanel();
        keyPanel.setExtraDataUI((JComponent)((Object)keyStrengthPanel));
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback(keyPanel.getError() != null ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
            int result = JOptionPane.showConfirmDialog(parent, (Object)keyPanel, resources.getString("writeKeyDialog.title"), 2, 3);
            if (result != 0) break;
            if (keyPanel.updateParam(param)) {
                param.setKeyStrength(keyStrengthPanel.getKeyStrength());
                controller.setKey(param);
                break;
            }
            assert (keyPanel.getError() != null);
        }
    }

    @Override
    public void promptReadKey(final PromptingKeyProvider.Controller<AesCipherParameters> controller, final boolean invalid) throws UnknownKeyException {
        class PromptReadKey
        implements Runnable {
            PromptReadKey() {
            }

            @Override
            public void run() {
                AesCipherParametersView.this.promptReadKeyEDT(controller, invalid);
            }
        }
        AesCipherParametersView.multiplexOnEDT(new PromptReadKey());
    }

    private void promptReadKeyEDT(PromptingKeyProvider.Controller<AesCipherParameters> controller, boolean invalid) {
        ReadKeyPanel keyPanel;
        assert (EventQueue.isDispatchThread());
        URI resource = controller.getResource();
        assert (null != resource);
        AesCipherParameters param = new AesCipherParameters();
        if (invalid) {
            ReadKeyPanel panel = readKeyPanels.get(resource);
            keyPanel = panel != null ? panel : new ReadKeyPanel();
            keyPanel.setError(resources.getString("invalidKey"));
        } else {
            keyPanel = new ReadKeyPanel();
        }
        readKeyPanels.put(resource, keyPanel);
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback(null != keyPanel.getError() ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
            int result = JOptionPane.showConfirmDialog(parent, (Object)keyPanel, resources.getString("readKeyDialog.title"), 2, 3);
            if (result != 0) {
                controller.setKey(null);
                break;
            }
            if (keyPanel.updateParam(param)) {
                controller.setKey(param);
                controller.setChangeRequested(keyPanel.isChangeKeySelected());
                break;
            }
            assert (keyPanel.getError() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void multiplexOnEDT(Runnable task) throws UnknownKeyException {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        Class<AesCipherParametersView> clazz = AesCipherParametersView.class;
        synchronized (AesCipherParametersView.class) {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (InterruptedException failure) {
                throw new KeyPromptingInterruptedException(failure);
            }
            catch (InvocationTargetException ex) {
                throw new UnknownKeyException(ex);
            }
            return;
        }
    }
}

