/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.sl;

import de.schlichtherle.truezip.fs.archive.zip.raes.PromptingKeyManagerService;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.spi.KeyManagerService;
import de.schlichtherle.truezip.util.ServiceLocator;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class KeyManagerLocator
implements KeyManagerProvider {
    public static final KeyManagerLocator SINGLETON = new KeyManagerLocator();

    private KeyManagerLocator() {
    }

    @Override
    public <K> KeyManager<K> get(Class<K> type) {
        return Boot.SERVICE.get(type);
    }

    private static class Boot {
        static final KeyManagerService SERVICE;

        private Boot() {
        }

        static {
            Logger logger = Logger.getLogger(KeyManagerLocator.class.getName(), KeyManagerLocator.class.getName());
            ServiceLocator locator = new ServiceLocator(KeyManagerLocator.class.getClassLoader());
            KeyManagerService service = (KeyManagerService)locator.getService(KeyManagerService.class, null);
            if (null == service) {
                KeyManagerService oldService = null;
                Iterator i = locator.getServices(KeyManagerService.class);
                while (i.hasNext()) {
                    service = (KeyManagerService)i.next();
                    logger.log(Level.CONFIG, "located", service);
                    if (null != oldService && oldService.getPriority() > service.getPriority()) {
                        service = oldService;
                    }
                    oldService = service;
                }
            }
            if (null != service) {
                logger.log(Level.CONFIG, "provided", service);
            } else {
                service = new PromptingKeyManagerService();
                logger.log(Level.CONFIG, "default", service);
            }
            SERVICE = service;
        }
    }
}

