/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.CipherReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.RaesAuthenticationException;
import de.schlichtherle.truezip.crypto.raes.RaesException;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesParametersException;
import de.schlichtherle.truezip.crypto.raes.RaesParametersProvider;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.Type0RaesReadOnlyFile;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class RaesReadOnlyFile
extends CipherReadOnlyFile {
    static short readUByte(byte[] b, int off) {
        return (short)(b[off] & 0xFF);
    }

    static int readUShort(byte[] b, int off) {
        return (b[off + 1] & 0xFF) << 8 | b[off] & 0xFF;
    }

    static long readUInt(byte[] b, int off) {
        off += 3;
        long v = (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        return v |= (long)b[off] & 0xFFL;
    }

    public static RaesReadOnlyFile getInstance(File file, RaesParameters params) throws FileNotFoundException, RaesParametersException, RaesException, IOException {
        DefaultReadOnlyFile rof = new DefaultReadOnlyFile(file);
        try {
            return RaesReadOnlyFile.getInstance((ReadOnlyFile)rof, params);
        }
        catch (IOException failure) {
            rof.close();
            throw failure;
        }
    }

    public static RaesReadOnlyFile getInstance(ReadOnlyFile rof, RaesParameters parameters) throws IOException {
        byte[] leadIn = new byte[5];
        rof.seek(0L);
        rof.readFully(leadIn);
        if (RaesReadOnlyFile.readUInt(leadIn, 0) != 1397047634L) {
            throw new RaesException("No RAES signature!");
        }
        short type = RaesReadOnlyFile.readUByte(leadIn, 4);
        switch (type) {
            case 0: {
                parameters = RaesReadOnlyFile.findParameters(Type0RaesParameters.class, parameters);
                return new Type0RaesReadOnlyFile(rof, (Type0RaesParameters)parameters);
            }
        }
        throw new RaesException("Unknown RAES type: " + type);
    }

    private static <P extends RaesParameters> P findParameters(Class<P> type, @CheckForNull RaesParameters parameters) throws RaesParametersException {
        if (null == parameters) {
            throw new RaesParametersException();
        }
        if (type.isAssignableFrom(parameters.getClass())) {
            return (P)parameters;
        }
        if (parameters instanceof RaesParametersProvider) {
            return RaesReadOnlyFile.findParameters(type, ((RaesParametersProvider)parameters).get(type));
        }
        throw new RaesParametersException();
    }

    RaesReadOnlyFile(@CheckForNull ReadOnlyFile rof) {
        super(rof);
    }

    public abstract Type0RaesParameters.KeyStrength getKeyStrength();

    public abstract void authenticate() throws RaesAuthenticationException, IOException;
}

