/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyPromptingCancelledException;
import de.schlichtherle.truezip.key.PromptingKeyManager;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.net.URI;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class PromptingKeyProvider<K extends SafeKey<K>>
extends SafeKeyProvider<K> {
    private final PromptingKeyManager<K> manager;
    private volatile State state = State.RESET;
    @CheckForNull
    private volatile URI resource;
    private volatile boolean changeRequested;

    PromptingKeyProvider(PromptingKeyManager<K> manager) {
        assert (null != manager);
        this.manager = manager;
    }

    private View<K> getView() {
        return this.manager.getView();
    }

    private State getState() {
        return this.state;
    }

    private void setState(State state) {
        assert (null != state);
        this.state = state;
    }

    @CheckForNull
    public URI getResource() {
        return this.resource;
    }

    void setResource(@CheckForNull URI resource) {
        this.resource = resource;
    }

    @Override
    protected void retrieveWriteKey() throws UnknownKeyException {
        this.getState().retrieveWriteKey(this);
    }

    @Override
    protected void retrieveReadKey(boolean invalid) throws UnknownKeyException {
        this.getState().retrieveReadKey(this, invalid);
    }

    @Override
    protected K getKey() {
        return this.getState().getKey(this);
    }

    @CheckForNull
    private K getKey0() {
        return super.getKey();
    }

    @Override
    public void setKey(@CheckForNull K key) {
        this.getState().setKey(this, key);
    }

    private void setKey0(@CheckForNull K key) {
        super.setKey(key);
    }

    private boolean isChangeRequested() {
        return this.changeRequested;
    }

    private void setChangeRequested(boolean changeRequested) {
        this.changeRequested = changeRequested;
    }

    public void resetCancelledKey() {
        this.getState().resetCancelledKey(this);
    }

    public void resetUnconditionally() {
        this.reset();
    }

    private void reset() {
        this.setChangeRequested(false);
        this.setKey0(null);
        this.setState(State.RESET);
    }

    @NotThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    private final class ReadController
    extends BaseController {
        ReadController(State state) {
            super(state);
        }

        @Override
        public K getKey() {
            throw new IllegalStateException();
        }
    }

    @NotThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    private final class WriteController
    extends BaseController {
        WriteController(State state) {
            super(state);
        }

        @Override
        public void setChangeRequested(boolean changeRequested) {
            throw new IllegalStateException();
        }
    }

    @NotThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    private abstract class BaseController
    implements Controller<K>,
    Closeable {
        @CheckForNull
        private State state;

        BaseController(State state) {
            this.state = state;
        }

        private State getState() {
            State state = this.state;
            if (null == state) {
                throw new IllegalStateException();
            }
            return state;
        }

        @Override
        public void close() {
            this.state = null;
        }

        @Override
        public URI getResource() {
            URI resource = this.getState().getResource(PromptingKeyProvider.this);
            if (null == resource) {
                throw new IllegalStateException();
            }
            return resource;
        }

        @Override
        public K getKey() {
            return this.getState().getKey(PromptingKeyProvider.this);
        }

        @Override
        public void setKey(K key) {
            this.getState().setKey(PromptingKeyProvider.this, key);
        }

        @Override
        public void setChangeRequested(boolean changeRequested) {
            this.getState().setChangeRequested(PromptingKeyProvider.this, changeRequested);
        }
    }

    @NotThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    public static interface Controller<K extends SafeKey<K>> {
        public URI getResource();

        @CheckForNull
        public K getKey();

        public void setKey(@CheckForNull K var1);

        public void setChangeRequested(boolean var1);
    }

    @ThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    public static interface View<K extends SafeKey<K>> {
        public void promptWriteKey(Controller<K> var1) throws UnknownKeyException;

        public void promptReadKey(Controller<K> var1, boolean var2) throws UnknownKeyException;
    }

    @ThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    private static enum State {
        RESET{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                State state;
                try {
                    PromptingKeyProvider<K> promptingKeyProvider = provider;
                    promptingKeyProvider.getClass();
                    WriteController controller = promptingKeyProvider.new WriteController(this);
                    try {
                        ((PromptingKeyProvider)provider).getView().promptWriteKey(controller);
                    }
                    finally {
                        controller.close();
                    }
                }
                finally {
                    state = ((PromptingKeyProvider)provider).getState();
                    if (this == state) {
                        state = CANCELLED;
                        ((PromptingKeyProvider)provider).setState(state);
                    }
                }
                state.retrieveWriteKey(provider);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                State state;
                do {
                    try {
                        PromptingKeyProvider<K> promptingKeyProvider = provider;
                        promptingKeyProvider.getClass();
                        ReadController controller = promptingKeyProvider.new ReadController(this);
                        try {
                            ((PromptingKeyProvider)provider).getView().promptReadKey(controller, invalid);
                        }
                        finally {
                            controller.close();
                        }
                    }
                    catch (KeyPromptingCancelledException ex) {
                        ((PromptingKeyProvider)provider).setState(1.CANCELLED);
                        throw ex;
                    }
                } while ((state = ((PromptingKeyProvider)provider).getState()) == this);
                state.retrieveReadKey(provider, false);
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
            }
        }
        ,
        PROVIDED{

            @Override
            <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                if (((PromptingKeyProvider)provider).isChangeRequested()) {
                    ((PromptingKeyProvider)provider).setChangeRequested(false);
                    RESET.retrieveWriteKey(provider);
                }
            }

            @Override
            <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                if (invalid) {
                    ((PromptingKeyProvider)provider).setState(2.RESET);
                    RESET.retrieveReadKey(provider, true);
                }
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
            }
        }
        ,
        CANCELLED{

            @Override
            <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                throw new KeyPromptingCancelledException();
            }

            @Override
            <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                throw new KeyPromptingCancelledException();
            }

            @Override
            <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> provider) {
                ((PromptingKeyProvider)provider).reset();
            }
        };


        abstract <K extends SafeKey<K>> void retrieveWriteKey(PromptingKeyProvider<K> var1) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void retrieveReadKey(PromptingKeyProvider<K> var1, boolean var2) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void resetCancelledKey(PromptingKeyProvider<K> var1);

        @CheckForNull
        final <K extends SafeKey<K>> K getKey(PromptingKeyProvider<K> provider) {
            return (K)((PromptingKeyProvider)provider).getKey0();
        }

        final <K extends SafeKey<K>> void setKey(PromptingKeyProvider<K> provider, @CheckForNull K key) {
            ((PromptingKeyProvider)provider).setKey0(key);
            ((PromptingKeyProvider)provider).setState(null != key ? State.PROVIDED : State.CANCELLED);
        }

        <K extends SafeKey<K>> void setChangeRequested(PromptingKeyProvider<K> provider, boolean changeRequested) {
            ((PromptingKeyProvider)provider).setChangeRequested(changeRequested);
        }

        @CheckForNull
        <K extends SafeKey<K>> URI getResource(PromptingKeyProvider<K> provider) {
            return provider.getResource();
        }
    }
}

