/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param.swing;

import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

@DefaultAnnotation(value={NonNull.class})
public class AesKeyStrengthPanel
extends EnhancedPanel {
    private static final long serialVersionUID = 5629581723148235643L;
    private static final String CLASS_NAME = AesKeyStrengthPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private final JComboBox<String> keyStrength = new JComboBox();

    public AesKeyStrengthPanel() {
        this.initComponents();
        this.keyStrength.setSelectedIndex(Type0RaesParameters.KeyStrength.BITS_256.ordinal());
    }

    private ComboBoxModel<String> createModel() {
        return new DefaultComboBoxModel<String>(new String[]{resources.getString("medium"), resources.getString("high"), resources.getString("ultra")});
    }

    private void initComponents() {
        JLabel keyStrengthLong = new JLabel();
        JLabel keyStrengthShort = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyStrength.setModel(this.createModel());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.keyStrength, gridBagConstraints);
        keyStrengthLong.setLabelFor(this.keyStrength);
        keyStrengthLong.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(keyStrengthLong, gridBagConstraints);
        keyStrengthShort.setLabelFor(this.keyStrength);
        keyStrengthShort.setText(resources.getString("keyStrength"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add(keyStrengthShort, gridBagConstraints);
    }

    public Type0RaesParameters.KeyStrength getKeyStrength() {
        return Type0RaesParameters.KeyStrength.values()[this.keyStrength.getSelectedIndex()];
    }

    public void setKeyStrength(Type0RaesParameters.KeyStrength keyStrength) {
        this.keyStrength.setSelectedIndex(keyStrength.ordinal());
    }

    static {
        assert (0 == Type0RaesParameters.KeyStrength.BITS_128.ordinal());
        assert (1 == Type0RaesParameters.KeyStrength.BITS_192.ordinal());
        assert (2 == Type0RaesParameters.KeyStrength.BITS_256.ordinal());
    }
}

