/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesDriver;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.LazyOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
public class ParanoidZipRaesDriver
extends ZipRaesDriver {
    public ParanoidZipRaesDriver(IOPoolProvider ioPoolProvider, KeyManagerProvider keyManagerProvider) {
        super(ioPoolProvider, keyManagerProvider);
    }

    @Override
    public final long getAuthenticationTrigger() {
        return Long.MAX_VALUE;
    }

    @Override
    public final OutputShop<ZipArchiveEntry> newOutputShop(FsModel model, OutputSocket<?> output, InputShop<ZipArchiveEntry> source) throws IOException {
        OutputStream out = new LazyOutputSocket(output).newOutputStream();
        try {
            RaesOutputStream ros = RaesOutputStream.getInstance(out, this.getRaesParameters(model));
            return this.newZipOutputShop(model, (OutputStream)((Object)ros), (ZipInputShop)source);
        }
        catch (IOException cause) {
            try {
                out.close();
            }
            catch (IOException ex) {
                throw (IOException)ex.initCause(cause);
            }
            throw cause;
        }
    }
}

