/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.CipherOutputStream;
import de.schlichtherle.truezip.crypto.param.KeyStrength;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesParametersException;
import de.schlichtherle.truezip.crypto.raes.RaesParametersProvider;
import de.schlichtherle.truezip.crypto.raes.Type0RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.Mac;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class RaesOutputStream
extends CipherOutputStream {
    static void klac(Mac klac, long length, byte[] buf) {
        for (int i = 0; i < 8; ++i) {
            klac.update((byte)length);
            length >>= 8;
        }
        int bufLength = klac.doFinal(buf, 0);
        assert (bufLength == buf.length);
    }

    public static RaesOutputStream getInstance(OutputStream out, @CheckForNull RaesParameters param) throws IOException {
        if (null == out) {
            throw new NullPointerException();
        }
        while (null != param) {
            if (param instanceof Type0RaesParameters) {
                return new Type0RaesOutputStream(out, (Type0RaesParameters)param);
            }
            if (!(param instanceof RaesParametersProvider)) break;
            param = ((RaesParametersProvider)param).get(RaesParameters.class);
        }
        throw new RaesParametersException("No suitable RAES parameters available!");
    }

    RaesOutputStream(@CheckForNull OutputStream out, @CheckForNull BufferedBlockCipher cipher) {
        super(out, cipher);
    }

    public abstract KeyStrength getKeyStrength();
}

