/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes.param;

import de.schlichtherle.truezip.crypto.raes.RaesKeyException;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesParametersProvider;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class KeyManagerRaesParameters
implements RaesParametersProvider {
    protected final KeyManager<AesCipherParameters> manager;
    protected final URI raes;

    public KeyManagerRaesParameters(KeyManagerProvider provider, URI raes) {
        this((KeyManager<AesCipherParameters>)provider.get(AesCipherParameters.class), raes);
    }

    public KeyManagerRaesParameters(KeyManager<AesCipherParameters> manager, URI raes) {
        if (null == manager || null == raes) {
            throw new NullPointerException();
        }
        this.manager = manager;
        this.raes = raes;
    }

    @Override
    public <P extends RaesParameters> P get(Class<P> type) {
        if (type.isAssignableFrom(Type0RaesParameters.class)) {
            return (P)new Type0();
        }
        return null;
    }

    private class Type0
    implements Type0RaesParameters {
        private Type0() {
        }

        @Override
        public char[] getWritePassword() throws RaesKeyException {
            KeyProvider provider = KeyManagerRaesParameters.this.manager.getKeyProvider(KeyManagerRaesParameters.this.raes);
            try {
                return ((AesCipherParameters)((Object)provider.getWriteKey())).getPassword();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public char[] getReadPassword(boolean invalid) throws RaesKeyException {
            KeyProvider provider = KeyManagerRaesParameters.this.manager.getKeyProvider(KeyManagerRaesParameters.this.raes);
            try {
                return ((AesCipherParameters)((Object)provider.getReadKey(invalid))).getPassword();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public Type0RaesParameters.KeyStrength getKeyStrength() throws RaesKeyException {
            KeyProvider provider = KeyManagerRaesParameters.this.manager.getKeyProvider(KeyManagerRaesParameters.this.raes);
            try {
                return (Type0RaesParameters.KeyStrength)((AesCipherParameters)((Object)provider.getWriteKey())).getKeyStrength();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public void setKeyStrength(Type0RaesParameters.KeyStrength keyStrength) throws RaesKeyException {
            AesCipherParameters param;
            KeyProvider provider = KeyManagerRaesParameters.this.manager.getKeyProvider(KeyManagerRaesParameters.this.raes);
            try {
                param = (AesCipherParameters)((Object)provider.getReadKey(false));
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
            param.setKeyStrength(keyStrength);
            provider.setKey((Object)param);
        }
    }
}

