/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.KeyManagerRaesParameters;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.archive.zip.OptionOutputSocket;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesController;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.LazyOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public abstract class ZipRaesDriver
extends JarDriver {
    private final KeyManagerProvider keyManagerProvider;

    public ZipRaesDriver(IOPoolProvider ioPoolProvider, KeyManagerProvider keyManagerProvider) {
        super(ioPoolProvider);
        if (null == keyManagerProvider) {
            throw new NullPointerException();
        }
        this.keyManagerProvider = keyManagerProvider;
    }

    public final boolean getPreambled() {
        return true;
    }

    protected final KeyManagerProvider getKeyManagerProvider() {
        return this.keyManagerProvider;
    }

    @CheckForNull
    protected RaesParameters raesParameters(FsModel model) {
        return new KeyManagerRaesParameters((KeyManager<AesCipherParameters>)this.getKeyManagerProvider().get(AesCipherParameters.class), this.mountPointUri(model));
    }

    protected abstract long getAuthenticationTrigger();

    protected final boolean check(ZipInputShop input, ZipArchiveEntry entry) {
        return input.length() > this.getAuthenticationTrigger();
    }

    public FsController<?> newController(FsModel model, FsController<?> parent) {
        return new ZipRaesController(this.superNewController(model, parent), this);
    }

    public ZipArchiveEntry newEntry(String path, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        return super.newEntry(path, type, template, mknod.set((Enum)FsOutputOption.COMPRESS).clear((Enum)FsOutputOption.ENCRYPT));
    }

    public final InputShop<ZipArchiveEntry> newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        ReadOnlyFile rof = input.newReadOnlyFile();
        try {
            RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance(rof, this.raesParameters(model));
            if (rrof.length() <= this.getAuthenticationTrigger()) {
                rrof.authenticate();
            }
            return this.newInputShop(model, (ReadOnlyFile)rrof);
        }
        catch (IOException ex) {
            rof.close();
            throw ex;
        }
    }

    public final OptionOutputSocket getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        options = options.clear((Enum)FsOutputOption.GROW);
        BitField options2 = options.set((Enum)FsOutputOption.STORE);
        return new OptionOutputSocket(controller.getOutputSocket(name, options2, template), options);
    }

    protected OutputShop<ZipArchiveEntry> newOutputShop(FsModel model, OptionOutputSocket output, @CheckForNull ZipInputShop source) throws IOException {
        OutputStream out = new LazyOutputSocket((OutputSocket)output).newOutputStream();
        try {
            RaesOutputStream ros = RaesOutputStream.getInstance(out, this.raesParameters(model));
            return this.newOutputShop(model, (OutputStream)((Object)ros), source);
        }
        catch (IOException ex) {
            out.close();
            throw ex;
        }
    }
}

