/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesKeyException;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.zip.KeyManagerController;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesDriver;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class ZipRaesController
extends KeyManagerController<ZipRaesDriver> {
    private static final String ROOT_PATH = FsEntryName.ROOT.getPath();

    ZipRaesController(FsController<?> controller, ZipRaesDriver driver) {
        super(controller, (ZipDriver)driver);
    }

    protected Class<?> getKeyType() {
        return AesCipherParameters.class;
    }

    protected Class<? extends IOException> getKeyExceptionType() {
        return RaesKeyException.class;
    }

    public FsEntry getEntry(FsEntryName name) throws IOException {
        try {
            return this.delegate.getEntry(name);
        }
        catch (FsFalsePositiveException ex) {
            if (!(ex.getCause() instanceof RaesKeyException)) {
                throw ex;
            }
            if (!name.isRoot()) {
                return null;
            }
            FsEntry entry = this.getParent().getEntry(this.getModel().getMountPoint().getPath().resolve(name).getEntryName());
            assert (null != entry);
            while (entry instanceof FsCovariantEntry) {
                entry = ((FsCovariantEntry)entry).getEntry();
            }
            FsCovariantEntry special = new FsCovariantEntry(ROOT_PATH);
            special.putEntry(Entry.Type.SPECIAL, ((ZipRaesDriver)this.driver).newEntry(ROOT_PATH, Entry.Type.SPECIAL, (Entry)entry));
            return special;
        }
    }
}

