/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.CipherReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.RaesException;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesParametersException;
import de.schlichtherle.truezip.crypto.raes.RaesParametersProvider;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.crypto.raes.Type0RaesReadOnlyFile;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class RaesReadOnlyFile
extends CipherReadOnlyFile {
    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    RaesReadOnlyFile(@CheckForNull @WillCloseWhenClosed ReadOnlyFile rof) {
        super(rof);
    }

    static short readUByte(byte[] b, int off) {
        return (short)(b[off] & 0xFF);
    }

    static int readUShort(byte[] b, int off) {
        return (b[off + 1] & 0xFF) << 8 | b[off] & 0xFF;
    }

    static long readUInt(byte[] b, int off) {
        off += 3;
        long v = (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        return v |= (long)b[off] & 0xFFL;
    }

    @CreatesObligation
    public static RaesReadOnlyFile getInstance(File file, @Nullable RaesParameters param) throws IOException {
        DefaultReadOnlyFile rof = new DefaultReadOnlyFile(file);
        try {
            return RaesReadOnlyFile.getInstance((ReadOnlyFile)rof, param);
        }
        catch (IOException ex) {
            rof.close();
            throw ex;
        }
    }

    @CreatesObligation
    public static RaesReadOnlyFile getInstance(@WillCloseWhenClosed ReadOnlyFile rof, @CheckForNull RaesParameters param) throws IOException {
        byte[] leadIn = new byte[5];
        rof.seek(0L);
        rof.readFully(leadIn);
        if (RaesReadOnlyFile.readUInt(leadIn, 0) != 1397047634L) {
            throw new RaesException("No RAES signature!");
        }
        short type = RaesReadOnlyFile.readUByte(leadIn, 4);
        switch (type) {
            case 0: {
                return new Type0RaesReadOnlyFile(rof, RaesReadOnlyFile.parameters(Type0RaesParameters.class, param));
            }
        }
        throw new RaesException("Unknown RAES type: " + type);
    }

    private static <P extends RaesParameters> P parameters(Class<P> type, @CheckForNull RaesParameters param) throws RaesParametersException {
        while (null != param) {
            if (type.isInstance(param)) {
                return (P)((RaesParameters)type.cast(param));
            }
            if (!(param instanceof RaesParametersProvider)) break;
            param = ((RaesParametersProvider)param).get(type);
        }
        throw new RaesParametersException("No suitable RAES parameters available!");
    }

    public abstract Type0RaesParameters.KeyStrength getKeyStrength();

    public abstract void authenticate() throws IOException;
}

